/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IDividable;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistBlockSlabWood;
import ru.liahim.mist.handlers.ServerEventHandler;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.item.ItemMistChisel;

public class MistWoodBlock
extends MistBlock
implements IDividable {
    public static final PropertyEnum<EnumAxis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumAxis.class);
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    private final int flammability;
    private final int fireSpeed;
    private Block stepBlock;
    private Block slabBlock;
    private Block wallBlock;
    private Block stairsBlock;

    public MistWoodBlock(float hardness, float resistance, int flammability, int fireSpeed, MapColor color) {
        super(Material.field_151575_d, color);
        this.func_149711_c(hardness);
        if (resistance > 0.0f) {
            this.func_149752_b(resistance);
        }
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.LOG)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y)));
        this.flammability = flammability;
        this.fireSpeed = fireSpeed;
    }

    public MistWoodBlock(float hardness, float resistance, int flammability, int fireSpeed) {
        this(hardness, resistance, flammability, fireSpeed, Material.field_151575_d.func_151565_r());
    }

    public MistWoodBlock(float hardness, int flammability, int fireSpeed, MapColor color) {
        this(hardness, -1.0f, flammability, fireSpeed, color);
    }

    public MistWoodBlock(float hardness, int flammability, int fireSpeed) {
        this(hardness, -1.0f, flammability, fireSpeed, Material.field_151575_d.func_151565_r());
    }

    public MistWoodBlock(float hardness, MapColor color) {
        this(hardness, -1.0f, 20, 5, color);
    }

    public MistWoodBlock(float hardness) {
        this(hardness, -1.0f, 20, 5, Material.field_151575_d.func_151565_r());
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        if (state.func_177229_b(TYPE) == EnumType.PLANK) {
            switch (facing.func_176740_k()) {
                case Z: {
                    return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Z));
                }
                case X: {
                    return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.X));
                }
                case Y: {
                    if (placer.func_174811_aO().func_176740_k() == EnumFacing.Axis.X) {
                        return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.NONE));
                    }
                    return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y));
                }
            }
        } else if (state.func_177229_b(AXIS) != EnumAxis.NONE) {
            switch (facing.func_176740_k()) {
                case Z: {
                    return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Z));
                }
                case X: {
                    return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.X));
                }
                case Y: {
                    return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y));
                }
            }
        }
        return state;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumAxis axis;
        EnumType type = (EnumType)((Object)state.func_177229_b(TYPE));
        ItemStack heldItem = player.func_184586_b(hand);
        boolean axe = heldItem.func_77973_b() instanceof ItemAxe;
        boolean chisel = heldItem.func_77973_b() instanceof ItemMistChisel;
        if (type != EnumType.PLANK && type != EnumType.DEBARKING && heldItem != null && (axe || chisel && type != EnumType.CHISELED) && ((axis = (EnumAxis)((Object)state.func_177229_b(AXIS))) == EnumAxis.NONE || EnumAxis.fromFacingAxis(side.func_176740_k()) != axis)) {
            if (!world.field_72995_K && !ServerEventHandler.isMulchDelay(player.func_110124_au())) {
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.CARVING.trigger((EntityPlayerMP)player, world, pos, true);
                }
                if (axe) {
                    if (type == EnumType.LOG) {
                        if (axis == EnumAxis.NONE) {
                            world.func_175656_a(pos, state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y)));
                        } else {
                            world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.CHISELED)));
                        }
                    } else if (type == EnumType.CHISELED) {
                        world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.DEBARKING)));
                    }
                } else if (type == EnumType.LOG && axis != EnumAxis.NONE) {
                    world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumType.CHISELED)));
                }
                ServerEventHandler.setMulchDelay(player.func_110124_au(), 5);
                heldItem.func_77972_a(1, (EntityLivingBase)player);
                ItemStack stack = new ItemStack(MistItems.MULCH);
                pos = pos.func_177972_a(side);
                EntityItem entity_item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                entity_item.func_174869_p();
                world.func_72838_d((Entity)entity_item);
            }
            return true;
        }
        return false;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return state.func_177229_b(TYPE) == EnumType.PLANK ? 4 : 1;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(TYPE) == EnumType.PLANK ? Item.func_150898_a((Block)this.getStepBlock(state)) : super.func_180660_a(state, rand, fortune);
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumType.PLANK) {
            return 0;
        }
        if (state.func_177229_b(AXIS) == EnumAxis.NONE) {
            return this.func_176201_c(state);
        }
        return this.func_176201_c(state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y)));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumType.PLANK) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.X))));
        }
        if (state.func_177229_b(AXIS) == EnumAxis.Y || state.func_177229_b(AXIS) == EnumAxis.NONE) {
            return super.func_180643_i(state);
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y))));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.LOG)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.CHISELED)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.DEBARKING)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.CHISELED)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.NONE)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.DEBARKING)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.NONE)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.PLANK)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.X)))));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpeed;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("axis")) continue;
            world.func_175656_a(pos, state.func_177231_a(prop));
            return true;
        }
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumAxis)((Object)state.func_177229_b(AXIS))) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Z));
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.X));
                    }
                    case Y: {
                        if (state.func_177229_b(TYPE) == EnumType.PLANK) {
                            return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.NONE));
                        }
                        return state;
                    }
                    case NONE: {
                        if (state.func_177229_b(TYPE) == EnumType.PLANK) {
                            return state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y));
                        }
                        return state;
                    }
                }
                return state;
            }
        }
        return state;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(TYPE) != EnumType.PLANK;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)((Object)EnumAxis.byMeta(meta & 3))).func_177226_a(TYPE, (Comparable)((Object)EnumType.byMeta(meta / 4)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumAxis)((Object)state.func_177229_b(AXIS))).getMeta() + ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta() * 4;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, TYPE});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (state.func_177229_b(TYPE) == EnumType.PLANK) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, 13);
        }
        if (state.func_177229_b(AXIS) == EnumAxis.NONE) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state.func_177226_a(AXIS, (Comparable)((Object)EnumAxis.Y))));
    }

    @Override
    public Block getFullBlock() {
        return this;
    }

    @Override
    public Block getStepBlock(IBlockState state) {
        return this.stepBlock;
    }

    @Override
    public IBlockState getSlabBlock(IBlockState state) {
        if (this.slabBlock instanceof MistBlockSlabWood) {
            boolean isRot = state.func_177230_c() instanceof BlockStairs && ((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176740_k() == EnumFacing.Axis.X;
            return this.slabBlock.func_176223_P().func_177226_a((IProperty)MistBlockSlabWood.ISROT, (Comparable)Boolean.valueOf(isRot));
        }
        return this.slabBlock.func_176223_P();
    }

    @Override
    public Block getWallBlock(IBlockState state) {
        return this.wallBlock;
    }

    @Override
    public Block getStairsBlock(IBlockState state) {
        return this.stairsBlock;
    }

    @Override
    public IBlockState getFullState(IBlockState state) {
        if (state.func_177230_c() instanceof BlockStairs) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.PLANK)).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.fromFacingAxis(((EnumFacing)state.func_177229_b((IProperty)BlockStairs.field_176309_a)).func_176746_e().func_176740_k())));
        }
        if (state.func_177230_c() instanceof MistBlockSlabWood) {
            return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.PLANK)).func_177226_a(AXIS, (Comparable)((Object)((Boolean)state.func_177229_b((IProperty)MistBlockSlabWood.ISROT) != false ? EnumAxis.Z : EnumAxis.X)));
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.PLANK));
    }

    public void setStepBlock(Block stepBlock) {
        this.stepBlock = stepBlock;
    }

    public void setWallBlock(Block wallBlock) {
        this.wallBlock = wallBlock;
    }

    public void setSlabBlock(Block slabBlock) {
        this.slabBlock = slabBlock;
    }

    public void setStairsBlock(Block stairBlock) {
        this.stairsBlock = stairBlock;
    }

    public static enum EnumAxis implements IStringSerializable
    {
        X("x", 1),
        Y("y", 0),
        Z("z", 2),
        NONE("none", 3);

        private static final EnumAxis[] META_LOOKUP;
        private final String name;
        private final int meta;

        private EnumAxis(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }

        public static EnumAxis byMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumAxis[EnumAxis.values().length];
            EnumAxis[] enumAxisArray = EnumAxis.values();
            int n = enumAxisArray.length;
            for (int i = 0; i < n; ++i) {
                EnumAxis axis;
                EnumAxis.META_LOOKUP[axis.getMeta()] = axis = enumAxisArray[i];
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        LOG("log", 0),
        CHISELED("chiseled", 1),
        DEBARKING("debarking", 2),
        PLANK("plank", 3);

        private static final EnumType[] META_LOOKUP;
        private final String name;
        private final int meta;

        private EnumType(String name, int meta) {
            this.name = name;
            this.meta = meta;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMeta()] = type = enumTypeArray[i];
            }
        }
    }
}

