/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IMistSoil;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeSapling;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public abstract class MistTreeTrunk
extends MistBlock
implements IPlantable,
IGrowable {
    public static final PropertyInteger SIZE = PropertyInteger.func_177719_a((String)"size", (int)0, (int)4);
    public static final PropertyBool NODE = PropertyBool.func_177716_a((String)"node");
    public static final PropertyDirection DIR = PropertyDirection.func_177712_a((String)"dir", (Predicate)new Predicate<EnumFacing>(){

        public boolean apply(@Nullable EnumFacing face) {
            return face != EnumFacing.DOWN;
        }
    });
    protected final boolean VGShift;
    protected final boolean GGShift;
    protected final boolean GVShift;
    protected final int maxBranchWidth;
    protected final int maxCapWidth;
    protected final MistTreeLeaves leaves;
    protected static final PropertyDirection LDIR = MistTreeLeaves.DIR;
    protected final int newGrowthChance;
    protected final int minBranchDistance;
    private final int growthSpeed;
    protected final int[] nodeDistance;

    public MistTreeTrunk(float hardness, int maxBranchWidth, int maxCapWidth, boolean VGShift, boolean GGShift, boolean GVShift, MistTreeLeaves leaves, int newGrowthChance, int minBranchDistance, int growthSpeed, int[] nodeDistance) {
        super(Material.field_151575_d, Material.field_151575_d.func_151565_r());
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(hardness);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.UP).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(false)));
        this.VGShift = VGShift;
        this.GGShift = GGShift;
        this.GVShift = GVShift;
        this.maxBranchWidth = MathHelper.func_76125_a((int)maxBranchWidth, (int)0, (int)3);
        this.maxCapWidth = maxCapWidth;
        this.leaves = leaves;
        this.newGrowthChance = newGrowthChance;
        this.minBranchDistance = minBranchDistance;
        this.growthSpeed = Math.max(1, growthSpeed);
        this.nodeDistance = nodeDistance;
        this.func_149675_a(true);
    }

    public int getGrowthSpeed() {
        return this.growthSpeed;
    }

    public MistTreeLeaves getLeaves() {
        return this.leaves;
    }

    public boolean isDesertTree() {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing dir = this.getDir(state);
        int size = (Integer)state.func_185899_b(source, pos).func_177229_b((IProperty)SIZE);
        if (size == 4) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        }
        double i = 0.0625 * (double)size;
        if (dir == EnumFacing.EAST) {
            if (size < 3) {
                return new AxisAlignedBB(-0.375 + i, 0.375 - i, 0.375 - i, 0.625 + i, 0.625 + i, 0.625 + i);
            }
            return new AxisAlignedBB(-0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
        }
        if (dir == EnumFacing.WEST) {
            if (size < 3) {
                return new AxisAlignedBB(0.375 - i, 0.375 - i, 0.375 - i, 1.375 - i, 0.625 + i, 0.625 + i);
            }
            return new AxisAlignedBB(0.125, 0.125, 0.125, 1.125, 0.875, 0.875);
        }
        if (dir == EnumFacing.SOUTH) {
            if (size < 3) {
                return new AxisAlignedBB(0.375 - i, 0.375 - i, -0.375 + i, 0.625 + i, 0.625 + i, 0.625 + i);
            }
            return new AxisAlignedBB(0.125, 0.125, -0.125, 0.875, 0.875, 0.875);
        }
        if (dir == EnumFacing.NORTH) {
            if (size < 3) {
                return new AxisAlignedBB(0.375 - i, 0.375 - i, 0.375 - i, 0.625 + i, 0.625 + i, 1.375 - i);
            }
            return new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 1.125);
        }
        if (size < 3) {
            return new AxisAlignedBB(0.375 - i, -0.375 + i, 0.375 - i, 0.625 + i, 0.625 + i, 0.625 + i);
        }
        return new AxisAlignedBB(0.125, -0.125, 0.125, 0.875, 0.875, 0.875);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(state, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_184812_l_()) {
            tooltip.add(I18n.func_135052_a((String)"tile.mist.live_tree.tooltip", (Object[])new Object[0]));
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (player.func_184812_l_() && heldItem.func_77973_b() instanceof ItemAxe) {
            if (!world.field_72995_K) {
                EnumFacing face = this.getDir(state);
                if (world.func_180495_p(pos.func_177972_a(face.func_176734_d())).func_177230_c() == this) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)NODE) == false)));
                } else {
                    int size = (Integer)state.func_177229_b((IProperty)SIZE);
                    if (size < 4) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size + 1)));
                    } else {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return ModConfig.dimension.enableUseBoneMeal && !MistWorld.isPosInFog(world, pos.func_177956_o());
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        BlockPos checkPos = pos;
        EnumFacing dir = this.getDir(state);
        ArrayList list = Lists.newArrayList();
        while (true) {
            IBlockState checkState = world.func_180495_p(checkPos.func_177972_a(dir));
            if (rand.nextInt(4) > 0 && checkState.func_177230_c() == this && this.getDir(checkState) == dir) {
                list.add(dir);
            } else {
                for (EnumFacing face : FacingHelper.NOTDOWN) {
                    if (face == dir.func_176734_d() || (checkState = world.func_180495_p(checkPos.func_177972_a(face))).func_177230_c() != this || this.getDir(checkState) != face) continue;
                    list.add(face);
                }
            }
            if (list.isEmpty()) break;
            checkPos = checkPos.func_177972_a((EnumFacing)list.get(rand.nextInt(list.size())));
            checkState = world.func_180495_p(checkPos);
            dir = this.getDir(checkState);
            list.clear();
            if (rand.nextInt(3) != 0) continue;
            this.growLeaves(world, checkPos, checkState, rand);
        }
        this.growLeaves(world, checkPos, world.func_180495_p(checkPos), rand);
    }

    private void growLeaves(World world, BlockPos pos, IBlockState state, Random rand) {
        for (EnumFacing face : FacingHelper.NOTDOWN) {
            BlockPos checkPos = pos.func_177972_a(face);
            IBlockState checkState = world.func_180495_p(checkPos);
            if (checkState.func_177230_c() != this.leaves || checkState.func_177229_b((IProperty)LDIR) != face) continue;
            checkState.func_177230_c().func_180650_b(world, checkPos, checkState, rand);
        }
        this.func_180650_b(world, pos, state, rand);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K && world.func_175726_f(pos).func_150802_k()) {
            EnumFacing dir = this.getDir(state);
            BlockPos checkPos = pos.func_177972_a(dir.func_176734_d());
            IBlockState checkState = world.func_180495_p(checkPos);
            if (checkState.func_177230_c() != this || this.getDir(checkState) == dir.func_176734_d()) {
                if (!world.isSideSolid(checkPos, dir)) {
                    world.func_175655_b(pos, false);
                }
            } else if (dir == EnumFacing.UP) {
                world.func_175656_a(pos, this.getUpState(world, state, checkState, checkPos));
            } else {
                checkPos = pos.func_177984_a();
                checkState = world.func_180495_p(checkPos);
                if (checkState.func_177230_c() == this && this.getDir(checkState) == EnumFacing.UP) {
                    world.func_175656_a(checkPos, this.getUpState(world, checkState, state, pos));
                }
            }
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        BlockPos basePos = pos.func_177972_a(side.func_176734_d());
        IBlockState soil = world.func_180495_p(basePos);
        return this.func_176196_c(world, pos) && (soil.func_177230_c() == this || side == EnumFacing.UP && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, basePos, side, (IPlantable)this));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            BlockPos downPos = pos.func_177977_b();
            IBlockState downState = world.func_180495_p(downPos);
            if (downState.func_177230_c() == this) {
                return this.getUpState(world, this.func_176223_P(), downState, downPos);
            }
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)facing);
    }

    private IBlockState getUpState(World world, IBlockState state, IBlockState baseState, BlockPos basePos) {
        EnumFacing dir = this.getDir(baseState);
        if (dir == EnumFacing.UP && !((Boolean)baseState.func_177229_b((IProperty)NODE)).booleanValue()) {
            return state.func_177226_a((IProperty)SIZE, baseState.func_177229_b((IProperty)SIZE));
        }
        return state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(Math.max(0, (Integer)baseState.func_185899_b((IBlockAccess)world, basePos).func_177229_b((IProperty)SIZE) - (this.GVShift && dir != EnumFacing.UP ? 1 : 0))));
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149686_d(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)NODE) == false && (Integer)state.func_177229_b((IProperty)SIZE) == 4;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.func_149686_d(state);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_149686_d(state);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)SIZE) == 4 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        this.destroyBranch(world, pos, state, true);
    }

    public void destroyBranch(World world, BlockPos pos, IBlockState state, boolean drop) {
        for (EnumFacing face : DIR.func_177700_c()) {
            if (face == this.getDir(state).func_176734_d()) continue;
            BlockPos posUp = pos.func_177972_a(face);
            IBlockState stateUp = world.func_180495_p(posUp);
            if (stateUp.func_177230_c() == this && this.getDir(stateUp) == face) {
                world.func_175656_a(posUp, this.getActualState((IBlockAccess)world, stateUp, state, posUp, this.getDir(stateUp)));
                world.func_175655_b(posUp, drop);
                continue;
            }
            if (!(stateUp.func_177230_c() instanceof MistTreeLeaves) || stateUp.func_177229_b((IProperty)LDIR) != face) continue;
            world.func_175655_b(posUp, drop);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing face = this.getDir(state);
        if (face == EnumFacing.UP && !((Boolean)state.func_177229_b((IProperty)NODE)).booleanValue()) {
            return state.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(this.checkCornerCap(world, pos, face, (Integer)state.func_177229_b((IProperty)SIZE)))).func_177226_a((IProperty)DIR, (Comparable)face);
        }
        BlockPos basePos = pos.func_177972_a(face.func_176734_d());
        IBlockState base = world.func_180495_p(basePos);
        if (base.func_177230_c() == this && this.getDir(base) != face.func_176734_d()) {
            return this.getActualState(world, state, base.func_185899_b(world, basePos), pos, face);
        }
        return state.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(this.checkCornerCap(world, pos, face, (Integer)state.func_177229_b((IProperty)SIZE))));
    }

    private IBlockState getActualState(IBlockAccess world, IBlockState state, IBlockState base, BlockPos pos, EnumFacing face) {
        EnumFacing faceB = this.getDir(base);
        int sizeB = (Integer)base.func_177229_b((IProperty)SIZE);
        boolean node = (Boolean)state.func_177229_b((IProperty)NODE);
        boolean join = face != faceB;
        boolean canShift = this.canShift(face, faceB);
        int size = Math.max(0, Math.min(sizeB, join ? this.maxBranchWidth + (canShift ? 1 : 0) : 4) - (node ? 1 : 0) - (join && canShift ? 1 : 0));
        boolean corner = this.checkCornerCap(world, pos, face, size);
        return state.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(corner));
    }

    protected boolean canShift(EnumFacing face, EnumFacing faceB) {
        if (face == EnumFacing.UP) {
            return this.GVShift;
        }
        if (faceB == EnumFacing.UP) {
            return this.VGShift;
        }
        return this.GGShift;
    }

    private boolean checkCornerCap(IBlockAccess world, BlockPos pos, EnumFacing face, int size) {
        if (face == EnumFacing.UP && size > this.maxCapWidth) {
            IBlockState checkState = world.func_180495_p(pos.func_177984_a());
            return checkState.func_177230_c() == this && this.getDir(checkState) == EnumFacing.UP;
        }
        for (EnumFacing check : DIR.func_177700_c()) {
            IBlockState checkState;
            if (check == face.func_176734_d() || (checkState = world.func_180495_p(pos.func_177972_a(check))).func_177230_c() != this || this.getDir(checkState) != check) continue;
            return true;
        }
        return false;
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing fase = (EnumFacing)state.func_177229_b((IProperty)DIR);
        boolean node = (Boolean)state.func_177229_b((IProperty)NODE);
        if (fase == EnumFacing.EAST) {
            return (Integer)state.func_177229_b((IProperty)SIZE) == 4 ? 14 : 6 + (node ? 1 : 0);
        }
        if (fase == EnumFacing.WEST) {
            return (Integer)state.func_177229_b((IProperty)SIZE) == 4 ? 15 : 8 + (node ? 1 : 0);
        }
        if (fase == EnumFacing.NORTH) {
            return 10 + (node ? 1 : 0);
        }
        if (fase == EnumFacing.SOUTH) {
            return 12 + (node ? 1 : 0);
        }
        return node ? 5 : (Integer)state.func_177229_b((IProperty)SIZE);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 5) {
            return this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(meta));
        }
        if (meta == 5) {
            return this.func_176223_P().func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true));
        }
        if (meta < 8) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(meta == 7));
        }
        if (meta < 10) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(meta == 9));
        }
        if (meta < 12) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(meta == 11));
        }
        if (meta < 14) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(meta == 13));
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)(meta == 14 ? EnumFacing.EAST : EnumFacing.WEST)).func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (Integer)state.func_177229_b((IProperty)SIZE) == 4 ? state : state.func_177226_a((IProperty)DIR, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)DIR)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return (Integer)state.func_177229_b((IProperty)SIZE) == 4 ? state : state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)DIR)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIR, NODE, SIZE});
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1);
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return this.getDir(state) != EnumFacing.UP;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public EnumFacing getDir(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SIZE) == 4 ? EnumFacing.UP : (EnumFacing)state.func_177229_b((IProperty)DIR);
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int size = (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)SIZE);
        if (size == 0) {
            if (rand.nextBoolean()) {
                ret.add((Object)this.getBranch());
            } else {
                ret.add((Object)new ItemStack(Items.field_151055_y));
            }
        } else if (size == 1) {
            ret.add((Object)this.getBranch());
        } else if (size == 2) {
            ret.add((Object)this.getTrunk());
        } else if (size == 3) {
            if (rand.nextBoolean()) {
                ret.add((Object)this.getTrunk());
            } else {
                ret.add((Object)this.getBlock());
            }
        } else if (this.getNode() != null) {
            if (fortune > 3) {
                fortune = 3;
            }
            if (rand.nextInt(512) < 1 + fortune * 32) {
                ret.add((Object)this.getNode());
            } else {
                ret.add((Object)this.getBlock());
            }
        } else {
            ret.add((Object)this.getBlock());
        }
    }

    protected abstract ItemStack getBranch();

    protected abstract ItemStack getTrunk();

    protected abstract ItemStack getBlock();

    protected abstract ItemStack getNode();

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public boolean dropSapling(World world, BlockPos pos) {
        boolean sapling = false;
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)SIZE) == 0) {
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
            IBlockState upState = world.func_180495_p(pos.func_177972_a(dir));
            int count = 0;
            if (upState.func_177230_c() == this.leaves && upState.func_177229_b((IProperty)LDIR) == dir) {
                for (EnumFacing face : DIR.func_177700_c()) {
                    if (face == dir || face == dir.func_176734_d() || (upState = world.func_180495_p(pos.func_177972_a(face))).func_177230_c() != this.leaves || upState.func_177229_b((IProperty)LDIR) != face) continue;
                    ++count;
                }
                boolean bl = sapling = (double)world.field_73012_v.nextFloat() < (double)count * ModConfig.dimension.saplingsDropChance;
            }
        }
        if (sapling) {
            world.func_175655_b(pos, false);
            MistTreeTrunk.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getSapling());
        }
        return sapling;
    }

    protected ItemStack getSapling() {
        return new ItemStack(MistBlocks.TREE_SAPLING, 1, MistTreeSapling.EnumType.getMetaByTree(this));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            EnumFacing dir;
            int size = (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)SIZE);
            if (size <= this.getGrowingThickness(dir = this.getDir(state), rand)) {
                if (rand.nextInt(this.growthSpeed) == 0) {
                    IBlockState checkState;
                    EnumFacing opposite = dir.func_176734_d();
                    ArrayList<EnumFacing> availableGrowthDirection = new ArrayList<EnumFacing>();
                    boolean isBud = true;
                    for (EnumFacing checkDir : DIR.func_177700_c()) {
                        if (checkDir == opposite) continue;
                        checkState = world.func_180495_p(pos.func_177972_a(checkDir));
                        if (checkState.func_177230_c() == this.leaves && checkState.func_177229_b((IProperty)LDIR) == checkDir) {
                            availableGrowthDirection.add(checkDir);
                            continue;
                        }
                        if (!isBud || checkState.func_177230_c() != this || this.getDir(checkState) != checkDir) continue;
                        isBud = false;
                    }
                    if (this.canCheckBranch(world, pos, availableGrowthDirection, isBud, size, rand)) {
                        int counter = 1;
                        int totalLength = 1;
                        int branchLength = 0;
                        int firstSizeChangeDistance = 0;
                        int firstBendDistance = 0;
                        int firstBranchDistance = 0;
                        int trunckLength = 1;
                        BlockPos fixPos = null;
                        ArrayList<Integer> segments = new ArrayList<Integer>();
                        ArrayList<BlockPos> nodes = new ArrayList<BlockPos>();
                        if (((Boolean)state.func_177229_b((IProperty)NODE)).booleanValue()) {
                            segments.add(1);
                            nodes.add(pos);
                            counter = 0;
                        }
                        BlockPos rootPos = pos;
                        BlockPos downPos = pos.func_177972_a(opposite);
                        IBlockState rootState = state;
                        IBlockState downState = null;
                        int previousSize = size;
                        EnumFacing currentDir = dir;
                        EnumFacing previousDir = dir;
                        while ((downState = world.func_180495_p(downPos)).func_177230_c() == this) {
                            ++counter;
                            currentDir = this.getDir(downState);
                            if (currentDir == previousDir.func_176734_d()) {
                                world.func_175655_b(downPos, false);
                                return;
                            }
                            if (firstBranchDistance == 0 && totalLength <= this.minBranchDistance) {
                                for (EnumFacing branchDir : DIR.func_177700_c()) {
                                    if (firstBranchDistance != 0 || branchDir == previousDir || branchDir == currentDir.func_176734_d() || ((checkState = world.func_180495_p(downPos.func_177972_a(branchDir))).func_177230_c() != this || this.getDir(checkState) != branchDir) && (checkState.func_177230_c() != this.leaves || checkState.func_177229_b((IProperty)LDIR) != branchDir)) continue;
                                    firstBranchDistance = totalLength;
                                }
                            }
                            if (previousSize == 0 && (counter == 1 || currentDir != previousDir)) {
                                int curretnSize = (Integer)downState.func_185899_b((IBlockAccess)world, downPos).func_177229_b((IProperty)SIZE);
                                if (curretnSize > 0) {
                                    firstSizeChangeDistance = totalLength;
                                    previousSize = curretnSize;
                                }
                                if (counter == 1) {
                                    boolean check = false;
                                    if (curretnSize == 0) {
                                        check = true;
                                    } else if (curretnSize == 1 && currentDir != previousDir && this.canShift(previousDir, currentDir)) {
                                        check = true;
                                    }
                                    if (check) {
                                        world.func_175656_a(rootPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)previousDir));
                                        counter += ((Integer)segments.get(segments.size() - 1)).intValue();
                                        segments.remove(segments.size() - 1);
                                        nodes.remove(nodes.size() - 1);
                                    }
                                }
                            }
                            if (currentDir != previousDir) {
                                if (firstBendDistance == 0) {
                                    firstBendDistance = totalLength;
                                }
                                if ((checkState = world.func_180495_p(downPos.func_177972_a(currentDir))).func_177230_c() == this && this.getDir(checkState) == currentDir) {
                                    branchLength = totalLength;
                                    fixPos = downPos;
                                }
                                previousDir = currentDir;
                                trunckLength = 0;
                            }
                            if (((Boolean)downState.func_177229_b((IProperty)NODE)).booleanValue()) {
                                segments.add(counter);
                                nodes.add(downPos);
                                counter = 0;
                            }
                            ++trunckLength;
                            ++totalLength;
                            rootState = downState;
                            rootPos = downPos;
                            downPos = downPos.func_177972_a(currentDir.func_176734_d());
                        }
                        segments.add(counter);
                        long posRand = MistWorld.getPosRandom(world, rootPos, 0);
                        int soilDepth = this.getSoilDepth(world, rootPos);
                        int minTruckLength = this.getMinTrunckLength(world, rootPos, posRand, soilDepth);
                        int maxTreeHeight = this.getMaxTreeHeight(world, rootPos, minTruckLength, posRand, soilDepth);
                        int maxTruckLength = this.getMaxTrunckLength(world, rootPos, maxTreeHeight, minTruckLength, posRand, soilDepth);
                        int canGrowth = this.canGrowth(world, pos, state, size, dir, availableGrowthDirection, isBud, totalLength, branchLength, firstSizeChangeDistance, firstBendDistance, firstBranchDistance, trunckLength, minTruckLength, maxTruckLength, maxTreeHeight, segments, nodes, fixPos, rootPos, rootState, downPos, downState, rand);
                        if (canGrowth == 2) {
                            ArrayList<EnumFacing> growthDirs = this.chooseGrowthDir(world, pos, state, size, dir, availableGrowthDirection, isBud, totalLength, branchLength, firstSizeChangeDistance, firstBendDistance, firstBranchDistance, trunckLength, minTruckLength, maxTreeHeight, segments, nodes, fixPos, rootPos, rootState, rand);
                            if (!growthDirs.isEmpty()) {
                                boolean growth = false;
                                for (EnumFacing face : growthDirs) {
                                    if (!this.growth(world, pos, pos.func_177972_a(face), size, dir, face, availableGrowthDirection, totalLength, branchLength, firstSizeChangeDistance, firstBendDistance, firstBranchDistance, trunckLength, minTruckLength, maxTreeHeight, rootPos, rootState, downPos, downState, rand) || face != dir || segments.isEmpty()) continue;
                                    growth = true;
                                }
                                if (growth) {
                                    segments.set(0, segments.get(0) + 1);
                                    if (branchLength > 0) {
                                        ++branchLength;
                                    }
                                    if (firstSizeChangeDistance > 0) {
                                        ++firstSizeChangeDistance;
                                    }
                                    if (firstBendDistance > 0) {
                                        ++firstBendDistance;
                                    }
                                    if (firstBranchDistance > 0) {
                                        ++firstBranchDistance;
                                    }
                                    if (trunckLength == totalLength) {
                                        ++trunckLength;
                                    }
                                    ++totalLength;
                                }
                            }
                        } else if (canGrowth == 1) {
                            this.setNewLeaves(world, pos, state, size, dir, availableGrowthDirection, isBud, rootPos, rootState, downPos, downState, rand);
                        }
                        if (canGrowth > 0) {
                            if (!availableGrowthDirection.isEmpty()) {
                                int newNodeDistance;
                                ArrayList<BlockPos> shiftedNodes = this.getShiftedNodes(world, size, totalLength, branchLength, firstSizeChangeDistance, firstBendDistance, firstBranchDistance, segments, nodes, rand);
                                boolean lastNodeMoved = false;
                                if (!shiftedNodes.isEmpty()) {
                                    lastNodeMoved = true;
                                    for (BlockPos shiftPos : shiftedNodes) {
                                        if (!lastNodeMoved) continue;
                                        lastNodeMoved = this.shiftNode(world, shiftPos);
                                    }
                                }
                                if (lastNodeMoved) {
                                    segments.set(segments.size() - 1, segments.get(segments.size() - 1) + 1);
                                }
                                if ((newNodeDistance = this.newNodeDistance(world, rootPos, rootState, totalLength, branchLength, firstSizeChangeDistance, firstBendDistance, firstBranchDistance, trunckLength, minTruckLength, maxTreeHeight, segments, rand)) > 0) {
                                    this.createNewNode(world, rootPos, rootState, newNodeDistance);
                                }
                            }
                        } else if (canGrowth < 0) {
                            this.setDead(world, pos, state, size, dir, availableGrowthDirection, isBud, rand);
                        }
                    }
                }
            } else {
                IBlockState checkState;
                EnumFacing opposite = dir.func_176734_d();
                if (rand.nextInt(this.getDestroyChance(size)) == 0) {
                    ArrayList<EnumFacing> availableGrowthDirection = new ArrayList<EnumFacing>();
                    boolean isBud = true;
                    for (EnumFacing checkDir : DIR.func_177700_c()) {
                        if (checkDir == opposite) continue;
                        checkState = world.func_180495_p(pos.func_177972_a(checkDir));
                        if (checkState.func_177230_c() == this.leaves && checkState.func_177229_b((IProperty)LDIR) == checkDir) {
                            availableGrowthDirection.add(checkDir);
                            continue;
                        }
                        if (!isBud || checkState.func_177230_c() != this || this.getDir(checkState) != checkDir) continue;
                        isBud = false;
                    }
                    this.setDead(world, pos, state, size, dir, availableGrowthDirection, isBud, rand);
                } else {
                    dir = (EnumFacing)DIR.func_177700_c().toArray()[rand.nextInt(DIR.func_177700_c().size())];
                    BlockPos checkPos = pos.func_177972_a(dir);
                    checkState = world.func_180495_p(checkPos);
                    if (checkState.func_177230_c() == this.leaves && checkState.func_177229_b((IProperty)LDIR) == dir) {
                        world.func_175698_g(checkPos);
                    }
                }
                if (size == 4 && rand.nextInt(this.growthSpeed) == 0 && (checkState = world.func_180495_p(pos.func_177972_a(opposite))).func_177230_c() != this && SoilHelper.getHumus(checkState) != 3) {
                    this.makeOlder(world, pos, state, pos.func_177972_a(opposite), checkState, rand, false);
                }
            }
        }
    }

    protected int getSoilDepth(World world, BlockPos rootPos) {
        return 0;
    }

    protected int trySetDead(World world, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, boolean isBud, Random rand) {
        if ((Integer)rootState.func_177229_b((IProperty)SIZE) < 4 && rand.nextInt(this.growthSpeed * 1000) == 0) {
            SoilHelper.setSoil(world, soilPos, soil, 3, 2);
            return -1;
        }
        return isBud ? 1 : 0;
    }

    protected abstract int getMinTrunckLength(World var1, BlockPos var2, long var3, int var5);

    protected abstract int getMaxTreeHeight(World var1, BlockPos var2, int var3, long var4, int var6);

    protected int getMaxTrunckLength(World world, BlockPos rootPos, int maxTreeHeight, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength;
    }

    protected int getGrowingThickness(EnumFacing face, Random rand) {
        return 0;
    }

    protected boolean canCheckBranch(World world, BlockPos pos, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int size, Random rand) {
        return isBud || !availableGrowthDirection.isEmpty();
    }

    protected abstract int canGrowth(World var1, BlockPos var2, IBlockState var3, int var4, EnumFacing var5, ArrayList<EnumFacing> var6, boolean var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, ArrayList<Integer> var17, ArrayList<BlockPos> var18, @Nullable BlockPos var19, BlockPos var20, IBlockState var21, BlockPos var22, IBlockState var23, Random var24);

    protected abstract ArrayList<EnumFacing> chooseGrowthDir(World var1, BlockPos var2, IBlockState var3, int var4, EnumFacing var5, ArrayList<EnumFacing> var6, boolean var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, int var15, ArrayList<Integer> var16, ArrayList<BlockPos> var17, @Nullable BlockPos var18, BlockPos var19, IBlockState var20, Random var21);

    public void makeOlder(World world, BlockPos rootPos, IBlockState root, BlockPos soilPos, IBlockState soil, Random rand, boolean now) {
        if ((Integer)root.func_177229_b((IProperty)SIZE) == 4) {
            EnumFacing dir = (EnumFacing)root.func_177229_b((IProperty)DIR);
            if (dir == EnumFacing.UP) {
                if (now || rand.nextInt(2000) == 0) {
                    world.func_175656_a(rootPos, root.func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST));
                }
            } else if (dir == EnumFacing.EAST) {
                if (now || rand.nextInt(2000) == 0) {
                    world.func_175656_a(rootPos, root.func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST));
                }
            } else if (dir == EnumFacing.WEST) {
                if (!now) {
                    this.dissemination(world, rootPos, soilPos, soil, rand);
                }
                if (now || rand.nextInt(500) == 0) {
                    SoilHelper.setSoil(world, soilPos, soil, 3, 2);
                }
            }
        }
    }

    protected void dissemination(World world, BlockPos pos, BlockPos soilPos, IBlockState soil, Random rand) {
        if (rand.nextInt(10) == 0) {
            int randX = rand.nextInt(16) - 8;
            int randZ = rand.nextInt(16) - 8;
            BlockPos target = pos.func_177982_a(randX, 8, randZ);
            while (target.func_177956_o() > MistWorld.getFogMaxHight() && !(world.func_180495_p(target).func_177230_c() instanceof MistSoil)) {
                target = target.func_177977_b();
            }
            if (world.func_180495_p(target).func_177230_c() instanceof MistSoil && world.func_175678_i(target.func_177984_a()) && world.func_180495_p(target.func_177984_a()).func_185904_a().func_76222_j() && (double)world.func_175724_o(target.func_177984_a()) > 0.45) {
                world.func_175656_a(target.func_177984_a(), MistBlocks.TREE_SAPLING.func_176223_P().func_177226_a(MistTreeSapling.TYPE, (Comparable)((Object)MistTreeSapling.EnumType.getTypeByTree(this))));
                if (rand.nextBoolean()) {
                    SoilHelper.setSoil(world, soilPos, soil, 3, 2);
                }
            }
        }
    }

    protected boolean growth(World world, BlockPos oldPos, BlockPos newPos, int size, EnumFacing baseDir, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        boolean growth = false;
        boolean check = false;
        BlockPos targetPos = newPos.func_177972_a(dir);
        if (this.checkEnvironment(world, targetPos)) {
            world.func_175656_a(newPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(size > 0)));
            world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
            growth = true;
        } else if (branchLength == 0 && dir == baseDir) {
            for (EnumFacing face : DIR.func_177700_c()) {
                if (face == dir || face == dir.func_176734_d()) continue;
                targetPos = newPos.func_177972_a(face);
                if (face != EnumFacing.UP && rand.nextInt(3) != 0 || !this.checkEnvironment(world, targetPos)) continue;
                world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                check = true;
            }
            if (check) {
                world.func_175656_a(newPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(size > 0)));
                growth = true;
            }
        }
        if (growth) {
            for (EnumFacing face : DIR.func_177700_c()) {
                if (face == dir || face == dir.func_176734_d()) continue;
                targetPos = newPos.func_177972_a(face);
                IBlockState targetState = world.func_180495_p(targetPos);
                if (!this.checkEnvironment(world, targetPos, false) && (!check || targetState.func_177230_c() != this.leaves || targetState.func_177229_b((IProperty)LDIR) != face)) continue;
                if (availableGrowthDirection.contains(face)) {
                    if (world.func_180495_p(oldPos.func_177972_a(face)).func_177230_c() == this.leaves && this.isLeavesRemoved(world, totalLength, branchLength, minTrunckLength, trunckLength, firstBranchDistance, oldPos.func_177972_a(face), targetPos, face, rand)) {
                        world.func_175698_g(oldPos.func_177972_a(face));
                    }
                    world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                    continue;
                }
                if (face != EnumFacing.UP && rand.nextInt(dir == EnumFacing.UP ? 2 : 3) <= 0) continue;
                world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
            }
            if (this.removeHumus(world, soilPos, soil)) {
                this.makeSoil(world, soilPos, soil, rand);
            }
        }
        return growth;
    }

    protected boolean isLeavesRemoved(World world, int totalLength, int branchLength, int minTrunckLength, int trunckLength, int firstBranchDistance, BlockPos pos, BlockPos newPos, EnumFacing dir, Random rand) {
        return true;
    }

    protected boolean removeHumus(World world, BlockPos soilPos, IBlockState soilState) {
        int humus;
        return soilState.func_177230_c() instanceof MistSoil && (humus = SoilHelper.getHumus(soilState)) > 0 && SoilHelper.setSoil(world, soilPos, soilState, humus - 1, 2);
    }

    protected boolean checkEnvironment(World world, BlockPos pos) {
        return this.checkEnvironment(world, pos, true);
    }

    protected boolean checkEnvironment(World world, BlockPos pos, boolean checkLight) {
        return this.func_176196_c(world, pos) && (!checkLight || (double)this.checkLight(world, pos) > 0.45) && !(world.func_180495_p(pos).func_177230_c() instanceof BlockLiquid);
    }

    protected float checkLight(World world, BlockPos pos) {
        int block;
        int sky = world.func_175642_b(EnumSkyBlock.SKY, pos);
        if (sky < (block = world.func_175642_b(EnumSkyBlock.BLOCK, pos))) {
            return world.field_73011_w.func_177497_p()[block];
        }
        return world.field_73011_w.func_177497_p()[Math.max(sky - world.func_175657_ab(), 0)];
    }

    protected void setNewLeaves(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        EnumFacing face;
        if (isBud && this.newGrowthChance > 0 && rand.nextInt(this.newGrowthChance) == 0 && availableGrowthDirection.size() < (dir == EnumFacing.UP ? 5 : 4) && (face = !availableGrowthDirection.contains(dir) ? dir : (!availableGrowthDirection.contains(EnumFacing.UP) ? EnumFacing.UP : (EnumFacing)DIR.func_177700_c().toArray()[rand.nextInt(DIR.func_177700_c().size())])) != dir.func_176734_d()) {
            BlockPos checkPos = pos.func_177972_a(face);
            if (!availableGrowthDirection.contains(face) && this.checkEnvironment(world, checkPos)) {
                world.func_175656_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                if (this.removeHumus(world, soilPos, soil)) {
                    this.makeSoil(world, soilPos, soil, rand);
                }
            } else {
                IBlockState leaves = world.func_180495_p(checkPos);
                if (leaves.func_177230_c() == this.leaves && leaves.func_177229_b((IProperty)LDIR) == face) {
                    this.leaves.updateLeaves(world, checkPos, leaves, rootPos, rootState, soilPos, soil, rand);
                }
            }
        }
    }

    protected void setDead(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, Random rand) {
        if (!availableGrowthDirection.isEmpty()) {
            pos = pos.func_177972_a(availableGrowthDirection.get(rand.nextInt(availableGrowthDirection.size())));
            world.func_175698_g(pos);
            this.fertilizeSoil(world, pos, rand);
        } else if (isBud) {
            world.func_175698_g(pos);
            this.fertilizeSoil(world, pos, rand);
        }
    }

    protected void fertilizeSoil(World world, BlockPos pos, Random rand) {
        pos = pos.func_177977_b();
        while (pos.func_177956_o() > 112) {
            int hum;
            if (!world.isSideSolid(pos, EnumFacing.UP)) {
                if (world.isSideSolid(pos, EnumFacing.DOWN)) break;
                pos = pos.func_177977_b();
                continue;
            }
            IBlockState state = world.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof MistSoil) || (hum = SoilHelper.getHumus(state)) >= 2) break;
            SoilHelper.setSoil(world, pos, state, hum + 1, 2);
            break;
        }
    }

    protected ArrayList<BlockPos> getShiftedNodes(World world, int size, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, Random rand) {
        ArrayList<BlockPos> shiftedNodes = new ArrayList<BlockPos>();
        boolean moveAll = false;
        int total = 0;
        int i = 0;
        for (BlockPos pos : nodes) {
            int segment = segments.get(i);
            if (branchLength != 0 && (total += segment) > branchLength) continue;
            if (segment + (moveAll ? 1 : 0) > this.nodeDistance[i] + (i == 0 && firstSizeChangeDistance == this.nodeDistance[0] ? 1 : 0)) {
                moveAll = true;
                shiftedNodes.add(pos);
            }
            ++i;
        }
        return shiftedNodes;
    }

    protected boolean shiftNode(World world, BlockPos pos) {
        IBlockState oldNodeState = world.func_180495_p(pos);
        EnumFacing oldNodeDir = this.getDir(oldNodeState);
        ArrayList<BlockPos> newNodes = new ArrayList<BlockPos>();
        boolean move = true;
        for (EnumFacing checkDir : DIR.func_177700_c()) {
            if (!move || checkDir == oldNodeDir.func_176734_d()) continue;
            BlockPos checkPos = pos.func_177972_a(checkDir);
            IBlockState checkState = world.func_180495_p(checkPos);
            if (checkState.func_177230_c() == this && this.getDir(checkState) == checkDir) {
                int size = (Integer)checkState.func_185899_b((IBlockAccess)world, checkPos).func_177229_b((IProperty)SIZE);
                if (!((Boolean)checkState.func_177229_b((IProperty)NODE)).booleanValue()) {
                    if (size >= this.maxBranchWidth && checkDir != oldNodeDir) continue;
                    newNodes.add(checkPos);
                    continue;
                }
                if (checkDir == oldNodeDir || size < this.maxBranchWidth - 1) {
                    move = false;
                    newNodes.clear();
                    continue;
                }
                newNodes.add(checkPos);
                continue;
            }
            if (checkDir != oldNodeDir || (Integer)oldNodeState.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)SIZE) < this.maxCapWidth) continue;
            move = false;
            newNodes.clear();
        }
        if (move) {
            world.func_175656_a(pos, oldNodeState.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(false)));
            if (!newNodes.isEmpty()) {
                for (BlockPos newNodePos : newNodes) {
                    world.func_175656_a(newNodePos, world.func_180495_p(newNodePos).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)));
                }
            }
        }
        return move;
    }

    protected abstract int newNodeDistance(World var1, BlockPos var2, IBlockState var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, ArrayList<Integer> var12, Random var13);

    protected void createNewNode(World world, BlockPos rootPos, IBlockState rootState, int newNodeDistance) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (rootSize < 4) {
            boolean checkNode = false;
            BlockPos pos = rootPos;
            for (int i = 0; i <= newNodeDistance; ++i) {
                IBlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() == this && this.getDir(state) == EnumFacing.UP) {
                    BlockPos checkPos;
                    IBlockState checkState;
                    if (i < newNodeDistance) {
                        for (EnumFacing face : DIR.func_177700_c()) {
                            if (checkNode || face == EnumFacing.DOWN || (checkState = world.func_180495_p(checkPos = pos.func_177972_a(face))).func_177230_c() != this || this.getDir(checkState) != face || !((Boolean)checkState.func_177229_b((IProperty)NODE)).booleanValue() || (Integer)checkState.func_185899_b((IBlockAccess)world, checkPos).func_177229_b((IProperty)SIZE) >= this.maxBranchWidth - 1) continue;
                            checkNode = true;
                        }
                    }
                    if (checkNode || i == newNodeDistance) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)));
                        world.func_175656_a(rootPos, rootState.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(rootSize + 1)));
                        break;
                    }
                    for (EnumFacing face : DIR.func_177700_c()) {
                        if (face == EnumFacing.UP || face == EnumFacing.DOWN || (checkState = world.func_180495_p(checkPos = pos.func_177972_a(face))).func_177230_c() != this || this.getDir(checkState) != face || (Integer)checkState.func_185899_b((IBlockAccess)world, checkPos).func_177229_b((IProperty)SIZE) >= this.maxBranchWidth) continue;
                        world.func_175656_a(checkPos, checkState.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)));
                    }
                } else if (rootSize < this.maxCapWidth) {
                    world.func_175656_a(rootPos, rootState.func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(rootSize + 1)));
                }
                pos = pos.func_177984_a();
            }
        }
    }

    protected int getDestroyChance(int size) {
        return 8;
    }

    protected void makeSoil(World world, BlockPos soilPos, IBlockState soilState, Random rand) {
        if (soilState.func_177230_c() instanceof MistSoil && (this.isDesertTree() || ((Boolean)soilState.func_177229_b((IProperty)IWettable.WET)).booleanValue()) && SoilHelper.getHumus(soilState) < 2) {
            IBlockState checkState;
            ArrayList checkPoses = new ArrayList();
            ArrayList<BlockPos> wetSoil = new ArrayList<BlockPos>();
            ArrayList<BlockPos> idealSoil = new ArrayList<BlockPos>();
            BlockPos donorPos = null;
            wetSoil.add(soilPos);
            for (int i = 0; i < 3; ++i) {
                checkPoses.clear();
                checkPoses.addAll(wetSoil);
                wetSoil.clear();
                for (BlockPos pos : checkPoses) {
                    for (EnumFacing face : EnumFacing.field_82609_l) {
                        BlockPos checkPos = pos.func_177972_a(face);
                        if ((i != 0 || face == EnumFacing.UP) && (i <= 0 || checkPos == soilPos || checkPoses.contains(checkPos)) || !((checkState = world.func_180495_p(checkPos)).func_177230_c() instanceof MistSoil) || !this.isDesertTree() && !((Boolean)checkState.func_177229_b((IProperty)IWettable.WET)).booleanValue()) continue;
                        wetSoil.add(checkPos);
                        if (SoilHelper.getHumus(checkState) <= 0 || (checkState = world.func_180495_p(checkPos.func_177984_a())) == this && this.getDir(checkState) == EnumFacing.UP) continue;
                        idealSoil.add(checkPos);
                    }
                }
                if (idealSoil.isEmpty()) continue;
                donorPos = (BlockPos)idealSoil.get(rand.nextInt(idealSoil.size()));
                break;
            }
            if (donorPos != null) {
                checkState = world.func_180495_p(donorPos);
                SoilHelper.setSoil(world, donorPos, checkState, SoilHelper.getHumus(checkState) - 1, 2);
                SoilHelper.setSoil(world, soilPos, soilState, SoilHelper.getHumus(soilState) + 1, 2);
            }
        }
    }

    public abstract void generateTree(World var1, BlockPos var2, Random var3, boolean var4);

    public void generateTree(World world, BlockPos pos, Random rand) {
        this.generateTree(world, pos, rand, false);
    }

    public abstract void generateTrunk(World var1, BlockPos var2, Random var3, boolean var4);

    public void generateTrunk(World world, BlockPos pos, Random rand) {
        this.generateTrunk(world, pos, rand, false);
    }

    protected boolean createBud(World world, BlockPos pos, EnumFacing branchDir, boolean potential) {
        boolean check = false;
        if (this.checkEnvironment(world, pos.func_177972_a(branchDir.func_176734_d()), false)) {
            for (EnumFacing dir : DIR.func_177700_c()) {
                BlockPos checkPos;
                if (dir == branchDir || !this.checkEnvironment(world, checkPos = pos.func_177972_a(dir), false)) continue;
                check = true;
                if (potential) {
                    world.func_180501_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir), 2);
                    continue;
                }
                world.func_180501_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)), 2);
            }
        }
        return check;
    }

    protected boolean createBranch(World world, BlockPos pos, Random rand, boolean potential) {
        return this.createBranch(world, null, pos, null, rand, EnumFacing.DOWN, potential);
    }

    protected boolean createBranch(World world, IBlockState state, BlockPos pos, Random rand, boolean potential) {
        return this.createBranch(world, state, pos, null, rand, EnumFacing.DOWN, potential);
    }

    protected boolean createBranch(World world, BlockPos pos, BlockPos rootPos, Random rand, boolean potential) {
        return this.createBranch(world, null, pos, rootPos, rand, EnumFacing.DOWN, potential);
    }

    protected boolean createBranch(World world, @Nullable IBlockState state, BlockPos pos, @Nullable BlockPos rootPos, Random rand, EnumFacing maskDir, boolean potential) {
        boolean check = false;
        if (state == null) {
            state = world.func_180495_p(pos);
        }
        if (state.func_177230_c() == this) {
            EnumFacing branchDir = this.getDir(state);
            EnumFacing opposite = branchDir.func_176734_d();
            for (EnumFacing dir : DIR.func_177700_c()) {
                if (dir == opposite || dir == maskDir || !rand.nextBoolean() && dir != EnumFacing.UP && dir != branchDir) continue;
                BlockPos checkPos = pos.func_177972_a(dir);
                if (rootPos != null && !this.checkDistanse(checkPos, pos, rootPos) || !this.checkEnvironment(world, checkPos, false) || !this.createBud(world, checkPos, dir.func_176734_d(), potential)) continue;
                check = true;
                world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
            }
            if (!check) {
                state = world.func_180495_p(pos.func_177972_a(branchDir));
                if (state.func_177230_c() == this && this.getDir(state) == branchDir) {
                    check = true;
                } else if (this.createBud(world, pos, opposite, potential)) {
                    world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)branchDir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                    check = true;
                } else {
                    world.func_175698_g(pos);
                }
            }
        }
        return check;
    }

    protected boolean checkDistanse(BlockPos pos, BlockPos oldPos, BlockPos rootPos) {
        return rootPos.func_177951_i((Vec3i)oldPos) < rootPos.func_177951_i((Vec3i)pos);
    }

    protected void drainZone(World world, BlockPos pos, int dist, Random rand) {
        for (int x = -dist; x <= dist; ++x) {
            for (int y = -dist; y <= dist; ++y) {
                for (int z = -dist; z <= dist; ++z) {
                    BlockPos checkPos;
                    IBlockState checkState;
                    int summ = Math.abs(x) + Math.abs(y) + Math.abs(z);
                    if (summ <= 0 || summ > dist || !((checkState = world.func_180495_p(checkPos = pos.func_177982_a(x, y, z))).func_177230_c() instanceof MistSoil)) continue;
                    SoilHelper.setSoil(world, checkPos, checkState, Math.min(1, rand.nextInt(summ)), 18);
                }
            }
        }
    }

    protected void checkSnow(World world, BlockPos pos, int radius) {
        if (world.func_180494_b(pos).func_150559_j()) {
            for (int x = -radius; x <= radius; ++x) {
                block1: for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = world.func_175725_q(pos.func_177982_a(x, 0, z));
                    if (world.func_175708_f(checkPos, true)) {
                        world.func_180501_a(checkPos, Blocks.field_150431_aC.func_176223_P(), 2);
                    }
                    IBlockState checkState = world.func_180495_p(checkPos.func_177977_b());
                    int h = checkPos.func_177956_o() - 2;
                    if (!(checkState.func_177230_c() instanceof MistTreeLeaves) && checkState.func_177230_c() != this) continue;
                    for (int y = h; y > 112; --y) {
                        checkPos = pos.func_177982_a(x, y - h, z);
                        checkState = world.func_180495_p(checkPos);
                        if (checkState.func_177230_c() == Blocks.field_150431_aC) {
                            world.func_175698_g(checkPos);
                            continue block1;
                        }
                        if (checkState.func_185917_h()) continue block1;
                    }
                }
            }
        }
    }

    protected void generateSoilLump(World world, BlockPos pos, EnumFacing face, Random rand, boolean checkSnow) {
        BlockPos inPos = pos.func_177967_a(face, 1);
        IBlockState state = world.func_180495_p(pos = pos.func_177967_a(face, 2).func_177977_b());
        if (state.func_177230_c() instanceof IMistSoil && !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof IMistSoil) && world.func_180495_p(inPos).func_177230_c().func_176200_f((IBlockAccess)world, inPos)) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                world.func_175698_g(pos.func_177984_a());
            }
            if (checkSnow && world.func_175708_f(pos, false)) {
                world.func_175656_a(pos, Blocks.field_150431_aC.func_176223_P());
            } else {
                world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 2);
            }
            world.func_180501_a(inPos, state, 2);
            SoilHelper.setDirt(world, inPos.func_177977_b(), state, 2);
            if (checkSnow && world.func_175708_f(inPos.func_177984_a(), false)) {
                world.func_175656_a(inPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
            }
            for (EnumFacing side : EnumFacing.field_176754_o) {
                if (side == face.func_176734_d() || rand.nextInt(8) == 0) continue;
                int i = side == face ? 2 : 1;
                BlockPos outPos = pos.func_177972_a(side);
                inPos = outPos.func_177981_b(i).func_177967_a(face.func_176734_d(), i);
                state = world.func_180495_p(outPos);
                if (!(state.func_177230_c() instanceof IMistSoil) || world.func_180495_p(outPos.func_177977_b()).func_177230_c() instanceof IMistSoil || !world.func_180495_p(inPos).func_177230_c().func_176200_f((IBlockAccess)world, inPos)) continue;
                if (world.func_180495_p(outPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                    world.func_175698_g(outPos.func_177984_a());
                }
                if (checkSnow && world.func_175708_f(outPos, false)) {
                    world.func_175656_a(outPos, Blocks.field_150431_aC.func_176223_P());
                } else {
                    world.func_180501_a(outPos, Blocks.field_150350_a.func_176223_P(), 2);
                }
                world.func_180501_a(inPos, state, 2);
                SoilHelper.setDirt(world, inPos.func_177977_b(), state, 2);
                if (!checkSnow || !world.func_175708_f(inPos.func_177984_a(), false)) continue;
                world.func_175656_a(inPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
            }
        }
    }
}

