/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.world.MistWorld;

public class MistTreeSapling
extends BlockBush
implements IGrowable {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);

    public MistTreeSapling() {
        super(Material.field_151585_k);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumType.OAK)));
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149675_a(true);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return SAPLING_AABB;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return ModConfig.dimension.enableUseBoneMeal && !MistWorld.isPosInFog(world, pos.func_177956_o());
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        this.func_180650_b(world, pos, state, rand);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            IBlockState soil;
            MistTreeTrunk tree = ((EnumType)((Object)state.func_177229_b(TYPE))).tree;
            if (rand.nextInt(tree.getGrowthSpeed() * 2) == 0) {
                if (MistWorld.isPosInFog(world, pos)) {
                    world.func_175655_b(pos, false);
                } else {
                    IBlockState soil2 = world.func_180495_p(pos.func_177977_b());
                    int i = tree.canGrowth(world, pos, tree.func_176223_P(), 0, EnumFacing.UP, new ArrayList<EnumFacing>(), true, 1, 0, 0, 0, 0, 1, 5, 5, 10, new ArrayList<Integer>(), new ArrayList<BlockPos>(), null, pos, state, pos.func_177977_b(), soil2, rand);
                    if (i > 0) {
                        world.func_175656_a(pos, tree.func_176223_P());
                        world.func_175656_a(pos.func_177984_a(), tree.leaves.func_176223_P().func_177226_a((IProperty)MistTreeTrunk.LDIR, (Comparable)EnumFacing.UP).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                        tree.removeHumus(world, pos.func_177977_b(), world.func_180495_p(pos.func_177977_b()));
                    } else if (tree.isDesertTree()) {
                        if (soil2 instanceof IWettable && !((Boolean)soil2.func_177229_b((IProperty)IWettable.WET)).booleanValue() && MistWorld.getHumi(world, pos, 0.0f) >= 100.0f) {
                            world.func_175656_a(pos.func_177977_b(), soil2.func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true)));
                        }
                    } else if (i < 0) {
                        world.func_175698_g(pos);
                    }
                }
            } else if (tree.isDesertTree() && (soil = world.func_180495_p(pos.func_177977_b())) instanceof IWettable && !((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && MistWorld.getHumi(world, pos, 0.0f) >= 100.0f) {
                world.func_175656_a(pos.func_177977_b(), soil.func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true)));
            }
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.getMeta()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public static enum EnumType implements IStringSerializable
    {
        ACACIA("acacia", 0, (MistTreeTrunk)MistBlocks.ACACIA_TRUNK),
        ASPEN("aspen", 1, (MistTreeTrunk)MistBlocks.ASPEN_TRUNK),
        ATREE("a_tree", 2, (MistTreeTrunk)MistBlocks.A_TREE_TRUNK),
        BIRCH("birch", 3, (MistTreeTrunk)MistBlocks.BIRCH_TRUNK),
        OAK("oak", 4, (MistTreeTrunk)MistBlocks.OAK_TRUNK),
        PINE("pine", 5, (MistTreeTrunk)MistBlocks.PINE_TRUNK),
        POPLAR("poplar", 6, (MistTreeTrunk)MistBlocks.POPLAR_TRUNK),
        SNOW("snow", 7, (MistTreeTrunk)MistBlocks.SNOW_TRUNK),
        SPRUCE("spruce", 8, (MistTreeTrunk)MistBlocks.SPRUSE_TRUNK),
        STREE("s_tree", 9, (MistTreeTrunk)MistBlocks.S_TREE_TRUNK),
        TTREE("t_tree", 10, (MistTreeTrunk)MistBlocks.T_TREE_TRUNK),
        WILLOW("willow", 11, (MistTreeTrunk)MistBlocks.WILLOW_TRUNK),
        RTREE("r_tree", 12, (MistTreeTrunk)MistBlocks.R_TREE_TRUNK);

        private static final EnumType[] META_LOOKUP;
        private static final HashMap<MistTreeTrunk, EnumType> TREE_LOOKUP;
        private final String name;
        private final int meta;
        private final MistTreeTrunk tree;

        private EnumType(String name, int meta, MistTreeTrunk tree) {
            this.name = name;
            this.meta = meta;
            this.tree = tree;
        }

        public int getMeta() {
            return this.meta;
        }

        public MistTreeTrunk getTree() {
            return this.tree;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMeta(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static int getMetaByTree(MistTreeTrunk tree) {
            if (TREE_LOOKUP.containsKey((Object)tree)) {
                return TREE_LOOKUP.get((Object)tree).getMeta();
            }
            return 0;
        }

        public static EnumType getTypeByTree(MistTreeTrunk tree) {
            if (TREE_LOOKUP.containsKey((Object)tree)) {
                return TREE_LOOKUP.get((Object)tree);
            }
            return OAK;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            TREE_LOOKUP = new HashMap();
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMeta()] = type = enumTypeArray[i];
                TREE_LOOKUP.put(type.getTree(), type);
            }
        }
    }
}

