/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.util.WorldUtil;
import ru.liahim.mist.world.MistWorld;

public class MistTreeLeavesWeeping
extends MistTreeLeaves {
    private final int leavesCount;

    public MistTreeLeavesWeeping(int baseColor, int leavesCount, int bloomMonth, int spoilMonth) {
        super(baseColor, bloomMonth, spoilMonth);
        this.leavesCount = leavesCount;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        block7: {
            EnumFacing dir;
            block8: {
                IBlockState checkState;
                int i;
                if (this.leavesCount <= 0) break block7;
                dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
                if (dir != EnumFacing.DOWN) break block8;
                if (this.leavesCount <= 1) break block7;
                int count = 0;
                for (i = 1; i <= this.leavesCount && (checkState = world.func_180495_p(pos.func_177981_b(i))).func_177230_c() == this; ++i) {
                    EnumFacing checkDir = (EnumFacing)checkState.func_177229_b((IProperty)DIR);
                    if (checkDir == EnumFacing.UP) {
                        i = 5;
                        continue;
                    }
                    if (checkDir == EnumFacing.DOWN) continue;
                    count = i;
                    break;
                }
                if (count > 0) {
                    count = this.leavesCount - count;
                }
                if (count > 0) {
                    for (i = 1; i <= count && (checkState = world.func_180495_p(pos.func_177979_c(i))).func_177230_c() == this && checkState.func_177229_b((IProperty)DIR) == EnumFacing.DOWN; ++i) {
                        world.func_175698_g(pos.func_177979_c(i));
                    }
                }
                break block7;
            }
            if (dir != EnumFacing.UP) {
                IBlockState checkState;
                for (int i = 1; i <= this.leavesCount && (checkState = world.func_180495_p(pos.func_177979_c(i))).func_177230_c() == this && checkState.func_177229_b((IProperty)DIR) == EnumFacing.DOWN; ++i) {
                    world.func_175698_g(pos.func_177979_c(i));
                }
            }
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
        MistTreeLeaves.EnumAge age = (MistTreeLeaves.EnumAge)((Object)state.func_177229_b((IProperty)AGE));
        if (age == MistTreeLeaves.EnumAge.EMPTY || dir == EnumFacing.UP) {
            return dir.func_176745_a();
        }
        if (dir == EnumFacing.DOWN) {
            if (age == MistTreeLeaves.EnumAge.POTENTIAL) {
                return 6;
            }
            return 11;
        }
        if (age == MistTreeLeaves.EnumAge.POTENTIAL) {
            return dir.func_176745_a() + 5;
        }
        return dir.func_176745_a() + 10;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta < 6) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_82600_a((int)meta)).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY));
        }
        if (meta < 11) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)(meta == 6 ? EnumFacing.DOWN : EnumFacing.func_82600_a((int)(meta - 5)))).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL));
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)(meta == 11 ? EnumFacing.DOWN : EnumFacing.func_82600_a((int)(meta - 10)))).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            IBlockState leaves;
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
            if (dir != EnumFacing.DOWN) {
                BlockPos basePos = pos.func_177972_a(dir.func_176734_d());
                IBlockState baseState = world.func_180495_p(basePos);
                if (baseState.func_177230_c() != this.trunkBlock) {
                    world.func_175698_g(pos);
                    return;
                }
                if (rand.nextInt(this.trunkBlock.getGrowthSpeed()) == 0 && dir != EnumFacing.UP) {
                    int count = (int)MistWorld.getPosRandom(world, pos, this.leavesCount + (this.leavesCount > 1 ? 0 : 1)) + (this.leavesCount > 1 ? 1 : 0);
                    for (int i = 1; i <= count; ++i) {
                        BlockPos checkPos = pos.func_177979_c(i);
                        IBlockState checkState = world.func_180495_p(checkPos);
                        if (checkState.func_177230_c() == this) {
                            if (checkState.func_177229_b((IProperty)DIR) != EnumFacing.DOWN) {
                                i = this.leavesCount + 1;
                                continue;
                            }
                            if (i != count || (checkState = world.func_180495_p(checkPos = checkPos.func_177977_b())).func_177230_c() != this || checkState.func_177229_b((IProperty)DIR) != EnumFacing.DOWN) continue;
                            world.func_175698_g(checkPos);
                            continue;
                        }
                        if (!this.trunkBlock.checkEnvironment(world, checkPos)) break;
                        while ((baseState = world.func_180495_p(basePos = basePos.func_177972_a(((EnumFacing)baseState.func_177229_b((IProperty)MistTreeTrunk.DIR)).func_176734_d()))).func_177230_c() == this.trunkBlock) {
                        }
                        if (!(baseState.func_177230_c() instanceof MistSoil) || SoilHelper.getHumus(baseState) <= 0) break;
                        world.func_175656_a(checkPos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                        return;
                    }
                }
            }
            if (dir != EnumFacing.UP && (leaves = this.getSeasonState(world, pos, state, MistTime.getTickOfMonth(world))) != null) {
                world.func_175656_a(pos, leaves);
            }
        }
    }

    @Override
    public void updateLeaves(World world, BlockPos pos, IBlockState state, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        int count;
        if (state.func_177229_b((IProperty)DIR) != EnumFacing.UP && rand.nextInt(MistTime.getDayInMonth()) == 0 && (count = (int)MistWorld.getPosRandom(world, pos, this.leavesCount + (this.leavesCount > 1 ? 0 : 1)) + (this.leavesCount > 1 ? 1 : 0)) > 0) {
            IBlockState leaves;
            count = rand.nextInt(count) + 1;
            BlockPos lPos = pos;
            for (int i = 0; i < count && (leaves = world.func_180495_p(lPos.func_177977_b())).func_177230_c() == this && leaves.func_177229_b((IProperty)DIR) == EnumFacing.DOWN; ++i) {
                lPos = lPos.func_177977_b();
            }
            leaves = world.func_180495_p(lPos);
            if (leaves.func_177230_c() == this && leaves.func_177229_b((IProperty)AGE) == MistTreeLeaves.EnumAge.EMPTY && (this.bloomMonth < this.spoilMonth ? MistTime.getMonth() < this.bloomMonth || MistTime.getMonth() > this.spoilMonth : MistTime.getMonth() > this.bloomMonth && MistTime.getMonth() < this.spoilMonth) && (Integer)rootState.func_177229_b((IProperty)MistTreeTrunk.SIZE) == 4 && (rootState.func_177229_b((IProperty)MistTreeTrunk.DIR) == EnumFacing.EAST || rootState.func_177229_b((IProperty)MistTreeTrunk.DIR) == EnumFacing.WEST) && (double)world.func_175724_o(lPos) > 0.45) {
                WorldUtil.simpleSetBlock(world, lPos, leaves.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL)));
            }
        }
    }

    @Override
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177229_b((IProperty)DIR) == EnumFacing.DOWN) {
            for (int i = 1; i <= this.leavesCount; ++i) {
                state = world.func_180495_p(pos.func_177981_b(i));
                if (state.func_177230_c() != this || state.func_177229_b((IProperty)DIR) == EnumFacing.DOWN) continue;
                return ret;
            }
        }
        ret.add(new ItemStack((Block)this));
        return ret;
    }
}

