/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.util.WorldUtil;
import ru.liahim.mist.world.MistWorld;

public class MistTreeLeavesSpreading
extends MistTreeLeaves {
    private final boolean blooming;

    public MistTreeLeavesSpreading(int baseColor, int bloomMonth, int spoilMonth, boolean blooming) {
        super(baseColor, bloomMonth, spoilMonth);
        this.blooming = blooming;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b((IProperty)DIR) != EnumFacing.DOWN && state.func_177229_b((IProperty)DIR) != EnumFacing.UP) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                IBlockState checkState = world.func_180495_p(pos.func_177972_a(face));
                if (checkState.func_177230_c() != this || checkState.func_177229_b((IProperty)DIR) != EnumFacing.DOWN) continue;
                world.func_175698_g(pos.func_177972_a(face));
            }
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
        MistTreeLeaves.EnumAge age = (MistTreeLeaves.EnumAge)((Object)state.func_177229_b((IProperty)AGE));
        if (age == MistTreeLeaves.EnumAge.EMPTY || dir != EnumFacing.DOWN) {
            return dir.func_176745_a();
        }
        if (age == MistTreeLeaves.EnumAge.POTENTIAL) {
            return 6;
        }
        if (age == MistTreeLeaves.EnumAge.BLOOMY) {
            return 7;
        }
        return 8;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta < 6) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_82600_a((int)meta)).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY));
        }
        if (meta == 6) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL));
        }
        if (meta == 7) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.BLOOMY));
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
            if (dir != EnumFacing.DOWN) {
                EnumFacing baseDir = dir.func_176734_d();
                BlockPos basePos = pos.func_177972_a(baseDir);
                IBlockState baseState = world.func_180495_p(basePos);
                if (baseState.func_177230_c() != this.trunkBlock) {
                    world.func_175698_g(pos);
                } else if (dir != EnumFacing.UP && rand.nextInt(Math.max(1, this.trunkBlock.getGrowthSpeed() / 2)) == 0 && (dir = EnumFacing.field_176754_o[rand.nextInt(4)]) != baseDir && this.func_176196_c(world, pos.func_177972_a(dir)) && this.trunkBlock.checkEnvironment(world, pos.func_177972_a(dir))) {
                    while ((baseState = world.func_180495_p(basePos = basePos.func_177972_a(((EnumFacing)baseState.func_177229_b((IProperty)MistTreeTrunk.DIR)).func_176734_d()))).func_177230_c() == this.trunkBlock) {
                    }
                    if (baseState.func_177230_c() instanceof MistSoil && SoilHelper.getHumus(baseState) > 0) {
                        world.func_175656_a(pos.func_177972_a(dir), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                    }
                }
            } else {
                IBlockState leaves = this.getSeasonState(world, pos, state, MistTime.getTickOfMonth(world));
                if (leaves != null) {
                    world.func_175656_a(pos, leaves);
                }
            }
        }
    }

    @Override
    public void updateLeaves(World world, BlockPos pos, IBlockState state, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        BlockPos lPos;
        IBlockState leaves;
        EnumFacing lDir;
        if (state.func_177229_b((IProperty)DIR) != EnumFacing.UP && rand.nextInt(MistTime.getDayInMonth()) == 0 && (lDir = EnumFacing.field_176754_o[rand.nextInt(4)]) != ((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176734_d() && (leaves = world.func_180495_p(lPos = pos.func_177972_a(lDir))).func_177230_c() == this && leaves.func_177229_b((IProperty)DIR) == EnumFacing.DOWN && leaves.func_177229_b((IProperty)AGE) == MistTreeLeaves.EnumAge.EMPTY) {
            int bloom;
            int n = bloom = this.blooming ? (this.bloomMonth + 12 - 1) % 12 : this.bloomMonth;
            if ((bloom < this.spoilMonth ? MistTime.getMonth() < bloom || MistTime.getMonth() > this.spoilMonth : MistTime.getMonth() > bloom && MistTime.getMonth() < this.spoilMonth) && (Integer)rootState.func_177229_b((IProperty)MistTreeTrunk.SIZE) > 2 && (rootState.func_177229_b((IProperty)MistTreeTrunk.DIR) == EnumFacing.EAST || rootState.func_177229_b((IProperty)MistTreeTrunk.DIR) == EnumFacing.WEST) && (double)world.func_175724_o(lPos) > 0.45) {
                WorldUtil.simpleSetBlock(world, lPos, leaves.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL)));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IBlockState getSeasonState(World world, BlockPos pos, IBlockState state, long monthTick) {
        if (state.func_177229_b((IProperty)DIR) != EnumFacing.DOWN || state.func_177229_b((IProperty)AGE) == MistTreeLeaves.EnumAge.EMPTY) return null;
        if (this.blooming && MistTime.getMonth() == (this.bloomMonth + 12 - 1) % 12) {
            long r;
            if (state.func_177229_b((IProperty)AGE) != MistTreeLeaves.EnumAge.POTENTIAL || (r = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L)) >= MistTime.getTickInMonth() || r >= monthTick) return null;
            return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.BLOOMY));
        }
        if (this.bloomMonth < this.spoilMonth ? MistTime.getMonth() >= this.bloomMonth && MistTime.getMonth() < this.spoilMonth : MistTime.getMonth() >= this.bloomMonth || MistTime.getMonth() < this.spoilMonth) {
            long r;
            if (this.blooming) {
                long r2;
                if (state.func_177229_b((IProperty)AGE) == MistTreeLeaves.EnumAge.BLOOMY) {
                    if (MistTime.getMonth() != this.bloomMonth) return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
                    long r3 = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L);
                    if (r3 >= MistTime.getTickInMonth() || r3 >= monthTick) return null;
                    return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
                }
                if (state.func_177229_b((IProperty)AGE) != MistTreeLeaves.EnumAge.POTENTIAL || MistTime.getMonth() != this.bloomMonth || (r2 = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L)) >= MistTime.getTickInMonth()) return null;
                return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.BLOOMY));
            }
            if (state.func_177229_b((IProperty)AGE) != MistTreeLeaves.EnumAge.POTENTIAL || (r = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L)) >= MistTime.getTickInMonth()) return null;
            if (MistTime.getMonth() != this.bloomMonth) return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
            if (r >= monthTick) return null;
            return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
        }
        if (state.func_177229_b((IProperty)AGE) == MistTreeLeaves.EnumAge.FRUIT) {
            if (MistTime.getMonth() != this.spoilMonth) return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL));
            long r = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L);
            if (r >= MistTime.getTickInMonth() || r >= monthTick) return null;
            return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL));
        }
        if (state.func_177229_b((IProperty)AGE) != MistTreeLeaves.EnumAge.POTENTIAL && state.func_177229_b((IProperty)AGE) != MistTreeLeaves.EnumAge.BLOOMY) return null;
        if (MistTime.getMonth() != this.spoilMonth) return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.POTENTIAL));
        long r = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L);
        if (r >= MistTime.getTickInMonth() || r < monthTick) return null;
        return state.func_177226_a((IProperty)AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.FRUIT));
    }

    @Override
    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177229_b((IProperty)DIR) == EnumFacing.DOWN) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                state = world.func_180495_p(pos.func_177972_a(face));
                if (state.func_177230_c() != this || state.func_177229_b((IProperty)DIR) == EnumFacing.DOWN) continue;
                return ret;
            }
        }
        ret.add(new ItemStack((Block)this));
        return ret;
    }
}

