/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IRubberBallCollideble;
import ru.liahim.mist.api.block.ISeasonalChanges;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityRubberBall;
import ru.liahim.mist.util.WorldUtil;
import ru.liahim.mist.world.MistWorld;

public class MistTreeLeaves
extends MistLeaves
implements ISeasonalChanges,
IRubberBallCollideble {
    public static final PropertyEnum<EnumAge> AGE = PropertyEnum.func_177709_a((String)"age", EnumAge.class);
    public static final PropertyBool FAST = PropertyBool.func_177716_a((String)"fast");

    public MistTreeLeaves(int baseColor, boolean mixColor, int bloomMonth, int spoilMonth) {
        super(baseColor, mixColor, bloomMonth, spoilMonth);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.DOWN).func_177226_a(AGE, (Comparable)((Object)EnumAge.POTENTIAL)).func_177226_a((IProperty)FAST, (Comparable)Boolean.valueOf(false)));
    }

    public MistTreeLeaves(int baseColor, int bloomMonth, int spoilMonth) {
        this(baseColor, true, bloomMonth, spoilMonth);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Blocks.field_150362_t.func_149662_c(state) ? state.func_177226_a((IProperty)FAST, (Comparable)Boolean.valueOf(true)) : state;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer instanceof EntityPlayer && ((EntityPlayer)placer).func_184812_l_() && facing != EnumFacing.DOWN && world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == this.getTrunkBlock()) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)facing).func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY));
        }
        return this.func_176223_P().func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(AGE) == EnumAge.FRUIT && side.func_176736_b() >= 0) {
            if (!world.field_72995_K) {
                this.spawnFruit(world, pos.func_177972_a(side));
                world.func_175656_a(pos, state.func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY)));
            }
            return true;
        }
        return false;
    }

    protected void spawnFruit(World world, BlockPos pos) {
        ItemStack stack = new ItemStack(MistItems.TREE_SEEDS, 1, this.trunkBlock.getSapling().func_77960_j());
        EntityItem entity_item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        entity_item.func_174869_p();
        world.func_72838_d((Entity)entity_item);
        world.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.2f, 1.5f);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
        if (dir == EnumFacing.DOWN) {
            return 0;
        }
        EnumAge age = (EnumAge)((Object)state.func_177229_b(AGE));
        if (age == EnumAge.EMPTY) {
            return dir.func_176745_a();
        }
        if (age == EnumAge.POTENTIAL) {
            return dir.func_176745_a() + 5;
        }
        return dir.func_176745_a() + 10;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        if (meta < 6) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_82600_a((int)meta)).func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY));
        }
        if (meta < 11) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_82600_a((int)(meta - 5))).func_177226_a(AGE, (Comparable)((Object)EnumAge.POTENTIAL));
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_82600_a((int)(meta - 10))).func_177226_a(AGE, (Comparable)((Object)EnumAge.FRUIT));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, DIR, FAST});
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        EnumFacing dir;
        if (!world.field_72995_K && (dir = (EnumFacing)state.func_177229_b((IProperty)DIR)) != EnumFacing.DOWN) {
            if (world.func_180495_p(pos.func_177972_a(dir.func_176734_d())).func_177230_c() != this.getTrunkBlock()) {
                world.func_175698_g(pos);
            } else {
                IBlockState leaves = this.getSeasonState(world, pos, state, MistTime.getTickOfMonth(world));
                if (leaves != null) {
                    world.func_175656_a(pos, leaves);
                }
            }
        }
    }

    @Override
    public void updateLeaves(World world, BlockPos pos, IBlockState state, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (rand.nextInt(MistTime.getDayInMonth()) == 0 && state.func_177229_b(AGE) == EnumAge.EMPTY && (this.bloomMonth < this.spoilMonth ? MistTime.getMonth() < this.bloomMonth || MistTime.getMonth() > this.spoilMonth : MistTime.getMonth() > this.bloomMonth && MistTime.getMonth() < this.spoilMonth) && (Integer)rootState.func_177229_b((IProperty)MistTreeTrunk.SIZE) == 4 && (rootState.func_177229_b((IProperty)MistTreeTrunk.DIR) == EnumFacing.EAST || rootState.func_177229_b((IProperty)MistTreeTrunk.DIR) == EnumFacing.WEST) && (double)world.func_175724_o(pos) > 0.45) {
            WorldUtil.simpleSetBlock(world, pos, state.func_177226_a(AGE, (Comparable)((Object)EnumAge.POTENTIAL)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IBlockState getSeasonState(World world, BlockPos pos, IBlockState state, long monthTick) {
        long r;
        if (state.func_177229_b(AGE) == EnumAge.EMPTY) return null;
        if (this.bloomMonth < this.spoilMonth ? MistTime.getMonth() >= this.bloomMonth && MistTime.getMonth() < this.spoilMonth : MistTime.getMonth() >= this.bloomMonth || MistTime.getMonth() < this.spoilMonth) {
            long r2;
            if (state.func_177229_b(AGE) != EnumAge.POTENTIAL || (r2 = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L)) >= MistTime.getTickInMonth()) return null;
            if (MistTime.getMonth() != this.bloomMonth) return state.func_177226_a(AGE, (Comparable)((Object)EnumAge.FRUIT));
            if (r2 >= monthTick) return null;
            return state.func_177226_a(AGE, (Comparable)((Object)EnumAge.FRUIT));
        }
        if (state.func_177229_b(AGE) == EnumAge.FRUIT) {
            if (MistTime.getMonth() != this.spoilMonth) return state.func_177226_a(AGE, (Comparable)((Object)EnumAge.POTENTIAL));
            long r3 = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L);
            if (r3 >= MistTime.getTickInMonth() || r3 >= monthTick) return null;
            return state.func_177226_a(AGE, (Comparable)((Object)EnumAge.POTENTIAL));
        }
        if (state.func_177229_b(AGE) != EnumAge.POTENTIAL || MistTime.getMonth() != this.spoilMonth || (r = MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() * 3L)) >= MistTime.getTickInMonth() || r < monthTick) return null;
        return state.func_177226_a(AGE, (Comparable)((Object)EnumAge.FRUIT));
    }

    @Override
    public boolean isCollide(World world, IBlockState state, EntityRubberBall ball, RayTraceResult result, Random rand) {
        if (!world.field_72995_K && state.func_177229_b(AGE) == EnumAge.FRUIT && ball.getMotion().func_189985_c() > 0.5) {
            this.spawnFruit(world, result.func_178782_a().func_177972_a(result.field_178784_b));
            world.func_175656_a(result.func_178782_a(), state.func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY)));
        }
        return true;
    }

    public static enum EnumAge implements IStringSerializable
    {
        EMPTY("empty"),
        POTENTIAL("potential"),
        BLOOMY("bloomy"),
        FRUIT("fruit");

        private final String name;

        private EnumAge(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

