/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import ru.liahim.mist.api.block.IMistStoneUpper;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistStoneMined;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.handlers.ServerEventHandler;
import ru.liahim.mist.init.ModAdvancements;

public class MistStoneUpper
extends MistBlock
implements IMistStoneUpper {
    public MistStoneUpper() {
        super(Material.field_151576_e);
        this.func_149711_c(100.0f);
        this.func_149752_b(1000.0f);
        this.setHarvestLevel("pickaxe", 0);
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == null) continue;
            ret.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        int skill = ISkillCapaHandler.Skill.getLevel((EntityPlayer)this.harvesters.get(), ISkillCapaHandler.Skill.MASON);
        if ((fortune += Math.max(skill - 2, 0)) > 3) {
            fortune = 3;
        }
        if (count < 4 && rand.nextInt(32 - fortune * 4) == 0) {
            ret.add((Object)new ItemStack(Items.field_191525_da));
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (!MistStoneUpper.checkConnection(world, pos)) {
                world.func_175655_b(pos, false);
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistBlocks.STONE_MINED));
                Pair<BlockPos, EntityPlayer> pair = ServerEventHandler.breakPlayer;
                if (pair != null && ((BlockPos)pair.getKey()).equals((Object)fromPos) && pair.getValue() instanceof EntityPlayerMP) {
                    ModAdvancements.STONE_MINED.trigger((EntityPlayerMP)pair.getValue(), new ItemStack(MistBlocks.STONE_MINED));
                }
            } else {
                this.checkFireBlock(world, pos);
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.checkFireBlock(world, pos);
    }

    private void checkFireBlock(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() == MistBlocks.CAMPFIRE || state.func_185904_a() == Material.field_151581_o || state.func_185904_a() == Material.field_151587_i) {
            world.func_175656_a(pos, MistBlocks.STONE_MINED.func_176223_P().func_177226_a(MistStoneMined.TYPE, (Comparable)((Object)MistStoneMined.EnumStoneType.NATURE)).func_177226_a(MistStoneMined.STAGE, (Comparable)((Object)MistStoneMined.EnumStoneStage.NORMAL)));
        }
    }

    public static boolean checkConnection(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (!world.isSideSolid(pos.func_177972_a(face), face.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        ISkillCapaHandler.getHandler(player).addSkill(ISkillCapaHandler.Skill.MASON, 2);
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MistItems.ROCKS;
    }

    public int func_149745_a(Random random) {
        return 2 + random.nextInt(3);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }
}

