/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IMistStoneUpper;
import ru.liahim.mist.api.block.IMossable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.block.MistStoneUpper;
import ru.liahim.mist.block.gizmos.MistCampfire;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.handlers.ServerEventHandler;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.network.PacketSpawnParticle;
import ru.liahim.mist.tileentity.TileEntityCampfire;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public class MistStoneMined
extends MistBlock
implements IMistStoneUpper,
IColoredBlock,
IMossable {
    public static final PropertyEnum<EnumStoneStage> STAGE = PropertyEnum.func_177709_a((String)"stage", EnumStoneStage.class);
    public static final PropertyEnum<EnumStoneType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumStoneType.class);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistStoneMined() {
        super(Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.MINED)).func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.NORMAL)));
        this.func_149675_a(true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && rand.nextBoolean()) {
            TileEntityCampfire fire;
            TileEntity tile;
            boolean campfire;
            IBlockState downState = world.func_180495_p(pos.func_177977_b());
            boolean bl = campfire = downState.func_177230_c() == MistBlocks.CAMPFIRE;
            if (campfire && (tile = world.func_175625_s(pos.func_177977_b())) instanceof TileEntityCampfire && (fire = (TileEntityCampfire)tile).getCookingTool() == MistCampfire.CookingTool.NONE && fire.getTemperature() > 20) {
                return;
            }
            Material downMat = downState.func_185904_a();
            EnumStoneType type = (EnumStoneType)((Object)state.func_177229_b(TYPE));
            EnumStoneStage stage = (EnumStoneStage)((Object)state.func_177229_b(STAGE));
            EnumStoneStage newStage = null;
            if (downMat == Material.field_151581_o || downMat == Material.field_151587_i) {
                newStage = MistStoneMined.updateHotStatus(world, pos, state);
            } else if (stage == EnumStoneStage.HOT_3) {
                newStage = EnumStoneStage.HOT_2;
            } else if (stage == EnumStoneStage.HOT_2) {
                newStage = EnumStoneStage.HOT_1;
            } else if (stage == EnumStoneStage.HOT_1) {
                if (type.isNature() && !campfire) {
                    world.func_175656_a(pos, MistBlocks.STONE.func_176223_P());
                    return;
                }
                newStage = EnumStoneStage.NORMAL;
            } else if (stage == EnumStoneStage.MOSS) {
                if (rand.nextBoolean() && MistWorld.isPosInFog(world, pos.func_177956_o())) {
                    newStage = EnumStoneStage.NORMAL;
                }
            } else if (stage == EnumStoneStage.NORMAL) {
                if (type.isNature()) {
                    if (!campfire) {
                        world.func_175656_a(pos, MistBlocks.STONE.func_176223_P());
                    }
                    return;
                }
                if (rand.nextInt(250) == 0 && !MistWorld.isPosInFog(world, pos.func_177956_o()) && world.func_180494_b(pos).func_76727_i() >= 0.3f) {
                    for (EnumFacing face : FacingHelper.NOTDOWN) {
                        if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                        return;
                    }
                    boolean check = false;
                    if (!world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                        for (EnumFacing side : EnumFacing.field_176754_o) {
                            if (!(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof MistGrass)) continue;
                            check = true;
                            break;
                        }
                    }
                    if (!check) {
                        for (EnumFacing side : EnumFacing.field_176754_o) {
                            if (world.isSideSolid(pos.func_177972_a(side), side.func_176734_d()) || !(world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() instanceof MistGrass)) continue;
                            check = true;
                            break;
                        }
                    }
                    if (check) {
                        newStage = EnumStoneStage.MOSS;
                    }
                }
            }
            if (newStage != null) {
                world.func_175656_a(pos, state.func_177226_a(STAGE, (Comparable)((Object)newStage)));
            }
        }
    }

    public static EnumStoneStage updateHotStatus(World world, BlockPos pos, IBlockState state) {
        EnumStoneStage stage = (EnumStoneStage)((Object)state.func_177229_b(STAGE));
        EnumStoneStage newStage = null;
        if (stage == EnumStoneStage.MOSS) {
            newStage = EnumStoneStage.NORMAL;
        } else if (stage == EnumStoneStage.NORMAL) {
            newStage = EnumStoneStage.HOT_1;
        } else if (stage == EnumStoneStage.HOT_1) {
            newStage = EnumStoneStage.HOT_2;
        } else if (stage == EnumStoneStage.HOT_2) {
            if (MistStoneMined.checkWater(state, world, pos.func_177984_a(), pos, EnumStoneStage.HOT_3)) {
                return null;
            }
            if (!world.func_175727_C(pos.func_177984_a())) {
                newStage = EnumStoneStage.HOT_3;
            } else {
                return null;
            }
        }
        return newStage;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && state.func_177229_b(STAGE) == EnumStoneStage.MOSS) {
            for (EnumFacing face : FacingHelper.NOTDOWN) {
                if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.func_176223_P());
                break;
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            EnumStoneStage stage = (EnumStoneStage)((Object)state.func_177229_b(STAGE));
            if (stage == EnumStoneStage.MOSS) {
                if (fromPos.func_177956_o() >= pos.func_177956_o() && world.func_180495_p(fromPos).func_177230_c() == MistBlocks.ACID_BLOCK) {
                    world.func_175656_a(pos, this.func_176223_P());
                }
            } else {
                int hot = stage.getHot();
                if (hot > 0) {
                    for (EnumFacing face : hot == 3 ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o) {
                        if (!MistStoneMined.checkWater(state, world, pos.func_177972_a(face), pos, stage)) continue;
                        return;
                    }
                }
                if (((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature()) {
                    IBlockState checkState;
                    if (!MistStoneUpper.checkConnection(world, pos)) {
                        world.func_175655_b(pos, false);
                        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack((Block)this));
                        Pair<BlockPos, EntityPlayer> pair = ServerEventHandler.breakPlayer;
                        if (pair != null && ((BlockPos)pair.getKey()).equals((Object)fromPos) && pair.getValue() instanceof EntityPlayerMP) {
                            ModAdvancements.STONE_MINED.trigger((EntityPlayerMP)pair.getValue(), new ItemStack(MistBlocks.STONE_MINED));
                        }
                    } else if (stage == EnumStoneStage.NORMAL && (checkState = world.func_180495_p(pos.func_177977_b())).func_177230_c() != MistBlocks.CAMPFIRE && checkState.func_185904_a() != Material.field_151581_o && checkState.func_185904_a() != Material.field_151587_i) {
                        world.func_175656_a(pos, MistBlocks.STONE.func_176223_P());
                    }
                }
            }
        }
    }

    protected static boolean checkWater(IBlockState state, World world, BlockPos pos, BlockPos center, EnumStoneStage stage) {
        IBlockState checkState = world.func_180495_p(pos);
        boolean water = checkState.func_185904_a() == Material.field_151586_h;
        boolean check = false;
        if (water || checkState.func_177230_c() == Blocks.field_150432_aD || checkState.func_177230_c() == Blocks.field_150433_aE) {
            if (water) {
                world.func_175698_g(pos);
            } else {
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
            }
            if (stage.getHot() == 3) {
                ((MistStoneMined)state.func_177230_c()).spawnBricks(world, pos, center);
            } else {
                world.func_175656_a(center, state.func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.NORMAL)));
            }
            check = true;
        } else if (checkState.func_177230_c() == Blocks.field_150431_aC) {
            world.func_175698_g(pos);
            check = true;
        }
        if (check) {
            world.func_184148_a((EntityPlayer)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 1.0f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketSpawnParticle(PacketSpawnParticle.ParticleType.CLOUD, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(Mist.getID(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 32.0));
        }
        return check;
    }

    protected void spawnBricks(World world, BlockPos waterPos, BlockPos pos) {
        int i;
        Pair<BlockPos, EntityPlayer> pair = ServerEventHandler.waterPlayer;
        int skill = 1;
        if (pair != null && ((BlockPos)pair.getKey()).equals((Object)waterPos)) {
            skill = ISkillCapaHandler.Skill.getLevel((EntityPlayer)pair.getValue(), ISkillCapaHandler.Skill.MASON);
            ISkillCapaHandler.getHandler((EntityPlayer)pair.getValue()).addSkill(ISkillCapaHandler.Skill.MASON, 10);
            if (pair.getValue() instanceof EntityPlayerMP) {
                ModAdvancements.BRICK.trigger((EntityPlayerMP)pair.getValue(), new ItemStack(MistItems.BRICK));
            }
        }
        world.func_184133_a(null, pos, MistSounds.BLOCK_STONE_BREAK, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
        world.func_175655_b(pos, false);
        int count = skill + world.field_73012_v.nextInt(world.field_73012_v.nextInt(2) + 1);
        if (count > 4) {
            count = 4;
        }
        for (i = 0; i < count; ++i) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistItems.BRICK));
        }
        for (i = 0; i < 4 - count; ++i) {
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistItems.ROCKS));
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature()) {
            ISkillCapaHandler.getHandler(player).addSkill(ISkillCapaHandler.Skill.MASON, 2);
        }
        super.func_180657_a(world, player, pos, state, te, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((EnumStoneStage)((Object)state.func_177229_b(STAGE))).getHot() == 3 && world.func_175727_C(pos.func_177984_a())) {
            double x = (double)pos.func_177958_n() + world.field_73012_v.nextDouble();
            double y = (double)pos.func_177956_o() + world.field_73012_v.nextDouble() * 0.2 + 1.1;
            double z = (double)pos.func_177952_p() + world.field_73012_v.nextDouble();
            world.func_175688_a(EnumParticleTypes.CLOUD, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f, true);
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        EnumStoneStage type = (EnumStoneStage)((Object)world.func_180495_p(pos).func_177229_b(STAGE));
        if (type == EnumStoneStage.HOT_3 && !entity.func_70045_F() && entity instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entity))) {
            entity.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        super.func_176199_a(world, pos, entity);
    }

    public void getDrops(NonNullList drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature()) {
            MistBlocks.STONE.getDrops(drops, world, pos, state, fortune);
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature() ? 100.0f : 3.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return ((EnumStoneType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).isNature() ? 1000.0f : 10.0f;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((EnumStoneStage)((Object)state.func_177229_b(STAGE))).getHot() * 4;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature() ? EnumPushReaction.BLOCK : EnumPushReaction.NORMAL;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).getMetadata() * 5 + ((EnumStoneStage)((Object)state.func_177229_b(STAGE))).getMetadata();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.byMetadata(meta / 5))).func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.byMetadata(meta % 5)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, TYPE});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature()) {
            return new ItemStack(Item.func_150898_a((Block)MistBlocks.STONE));
        }
        if (state.func_177229_b(STAGE) != EnumStoneStage.MOSS) {
            state = state.func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.NORMAL));
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.MINED)).func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.NORMAL)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.MINED)).func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.MOSS)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.CHISELED)).func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.NORMAL)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumStoneType.CHISELED)).func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.MOSS)))));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return state.func_177229_b(STAGE) == EnumStoneStage.MOSS ? layer == BlockRenderLayer.CUTOUT_MIPPED : layer == BlockRenderLayer.SOLID;
    }

    @Override
    public boolean isUpperStone(IBlockState state) {
        return ((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature();
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean setMossy(IBlockState state, World world, BlockPos pos) {
        if (!(state.func_177230_c() instanceof IMossable) || ((EnumStoneType)((Object)state.func_177229_b(TYPE))).isNature || state.func_177229_b(STAGE) != EnumStoneStage.NORMAL) {
            return false;
        }
        return world.func_175656_a(pos, state.func_177226_a(STAGE, (Comparable)((Object)EnumStoneStage.MOSS)));
    }

    public static enum EnumStoneStage implements IStringSerializable
    {
        NORMAL(0, "normal", 0),
        HOT_1(1, "hot_1", 1),
        HOT_2(2, "hot_2", 2),
        HOT_3(3, "hot_3", 3),
        MOSS(4, "moss", 0);

        private static final EnumStoneStage[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final int hot;

        private EnumStoneStage(int meta, String name, int hot) {
            this.meta = meta;
            this.name = name;
            this.hot = hot;
        }

        public int getMetadata() {
            return this.meta;
        }

        public int getHot() {
            return this.hot;
        }

        public static EnumStoneStage byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumStoneStage[EnumStoneStage.values().length];
            EnumStoneStage[] enumStoneStageArray = EnumStoneStage.values();
            int n = enumStoneStageArray.length;
            for (int i = 0; i < n; ++i) {
                EnumStoneStage type;
                EnumStoneStage.META_LOOKUP[type.getMetadata()] = type = enumStoneStageArray[i];
            }
        }
    }

    public static enum EnumStoneType implements IStringSerializable
    {
        MINED(0, "mined", false),
        CHISELED(1, "chiseled", false),
        NATURE(2, "nature", true);

        private static final EnumStoneType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final boolean isNature;

        private EnumStoneType(int meta, String name, boolean isNature) {
            this.meta = meta;
            this.name = name;
            this.isNature = isNature;
        }

        public int getMetadata() {
            return this.meta;
        }

        public boolean isNature() {
            return this.isNature;
        }

        public static EnumStoneType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumStoneType[EnumStoneType.values().length];
            EnumStoneType[] enumStoneTypeArray = EnumStoneType.values();
            int n = enumStoneTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumStoneType type;
                EnumStoneType.META_LOOKUP[type.getMetadata()] = type = enumStoneTypeArray[i];
            }
        }
    }
}

