/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import ru.liahim.mist.api.block.IMistSoil;
import ru.liahim.mist.block.MistBlockWettable;

public abstract class MistSoil
extends MistBlockWettable
implements IMistSoil {
    private Block soilBlock;
    private Block grassBlock;
    private Block farmBlock;

    public MistSoil(Material material, float hardness, int waterPerm) {
        super(material, waterPerm);
        this.func_149711_c(hardness);
        this.func_149672_a(material == Material.field_151577_b ? SoundType.field_185850_c : SoundType.field_185849_b);
        this.setHarvestLevel("shovel", 0);
        this.soilBlock = this;
        this.grassBlock = this;
        this.farmBlock = this;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        IBlockState plant = plantable.getPlant(world, pos.func_177972_a(direction));
        if (plant.func_177230_c() == Blocks.field_150330_I) {
            return true;
        }
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Plains: 
            case Cave: {
                return true;
            }
            case Beach: {
                return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    @Override
    public void setSoilBlock(Block soilBlock) {
        this.soilBlock = soilBlock;
    }

    @Override
    public Block getSoilBlock() {
        return this.soilBlock;
    }

    @Override
    public void setGrassBlock(Block grassBlock) {
        this.grassBlock = grassBlock;
    }

    @Override
    public Block getGrassBlock() {
        return this.grassBlock;
    }

    public void setFarmBlock(Block farmBlock) {
        this.farmBlock = farmBlock;
    }

    public Block getFarmBlock() {
        return this.farmBlock;
    }

    public IBlockState getFarmState(IBlockState state) {
        return this.getFarmBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET));
    }
}

