/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlockWettableFalling;

public class MistSapropel
extends MistBlockWettableFalling {
    public static final PropertyEnum<EnumBlockType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumBlockType.class);

    public MistSapropel() {
        super(Material.field_151571_B, 2);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE)).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean showPorosityTooltip() {
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? SoundType.field_185859_l : SoundType.field_185849_b;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0) : Block.field_185505_j;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
    }

    @Override
    protected boolean canFall(World world, BlockPos pos, IBlockState state, Random rand) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false && state.func_177229_b(TYPE) == EnumBlockType.BLOCK && (world.func_175623_d(pos.func_177977_b()) || MistSapropel.func_185759_i((IBlockState)world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0;
    }

    @Override
    public boolean setWet(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        return world.func_175656_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public boolean setDry(World world, BlockPos pos, IBlockState state, Random rand) {
        return world.func_180501_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)), 2);
    }

    @Override
    public boolean setAcid(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        return world.func_175655_b(pos, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)WET) != false ? 0 : 10;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == null) continue;
            ret.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (count < 3 && state.func_177229_b(TYPE) == EnumBlockType.NATURE && rand.nextInt(3 + count * 2) == 0) {
            if (rand.nextInt(8) == 0) {
                ret.add((Object)new ItemStack(Items.field_151103_aS));
            } else {
                ret.add((Object)new ItemStack(Items.field_151055_y));
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? MistItems.SAPROPEL_BALL : Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        return ((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() ? (state.func_177229_b(TYPE) == EnumBlockType.BLOCK ? 4 : rand.nextInt(3) + 1) : 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : this.func_176201_c(state);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumBlockType)((Object)state.func_177229_b(TYPE))).getMetadata() << 1 | ((Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : 1);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.byMetadata(meta >> 1))).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf((meta & 1) == 0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, WET});
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_193560_ab;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    @Override
    public void setAcidBlock(Block acidBlock) {
    }

    @Override
    public Block getAcidBlock(IBlockState state) {
        return null;
    }

    public static enum EnumBlockType implements IStringSerializable
    {
        BLOCK(0, "block"),
        NATURE(1, "nature");

        private static final EnumBlockType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumBlockType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumBlockType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumBlockType[EnumBlockType.values().length];
            EnumBlockType[] enumBlockTypeArray = EnumBlockType.values();
            int n = enumBlockTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumBlockType type;
                EnumBlockType.META_LOOKUP[type.getMetadata()] = type = enumBlockTypeArray[i];
            }
        }
    }
}

