/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.block.MistBlockWettableFalling;

public class MistSand
extends MistBlockWettableFalling {
    public static final PropertyEnum<BlockSand.EnumType> VARIANT = BlockSand.field_176504_a;

    public MistSand() {
        super(Material.field_151595_p, 3);
        this.func_149672_a(SoundType.field_185855_h);
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)BlockSand.EnumType.SAND).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean showPorosityTooltip() {
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Desert: 
            case Cave: {
                return true;
            }
            case Beach: {
                return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, (i & 1) == 0 ? i + 1 : i - 1));
        }
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        if (rand.nextInt(128) == 0) {
            ret.add((Object)new ItemStack(Items.field_151103_aS));
        } else {
            int count = this.quantityDropped(state, fortune, rand);
            for (int i = 0; i < count; ++i) {
                Item item = this.func_180660_a(state, rand, fortune);
                if (item == null) continue;
                ret.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
            }
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((BlockSand.EnumType)state.func_177229_b(VARIANT)).func_176688_a() << 1 | ((Boolean)state.func_177229_b((IProperty)WET) != false ? 1 : 0);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)BlockSand.EnumType.func_176686_a((int)(meta >> 1))).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, WET});
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((BlockSand.EnumType)state.func_177229_b(VARIANT)).func_176687_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        return state.func_177229_b(VARIANT) == BlockSand.EnumType.SAND ? -3618641 : -5679071;
    }

    @Override
    public int getTopProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 60 : 145;
    }

    @Override
    public int getSideProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 30 : 145;
    }

    @Override
    public int getCloseProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 45 : 120;
    }
}

