/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IMistStoneUpper;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistOre;
import ru.liahim.mist.common.Mist;

public class MistSaltpeterOre
extends MistOre
implements IMistStoneUpper {
    public static final PropertyEnum<SaltType> TYPE = PropertyEnum.func_177709_a((String)"type", SaltType.class);
    public static Item salt = null;

    public MistSaltpeterOre() {
        super(5.0f, 20.0f, 1, Material.field_151576_e.func_151565_r());
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)SaltType.NORMAL)));
    }

    @Override
    public boolean isUpperStone(IBlockState state) {
        return true;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        return state.func_177229_b(TYPE) == SaltType.SALT ? 100.0f : 5.0f;
    }

    public float getExplosionResistance(World world, BlockPos pos, @Nullable Entity exploder, Explosion explosion) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == SaltType.SALT ? 1000.0f : 20.0f;
    }

    public int getHarvestLevel(IBlockState state) {
        return state.func_177229_b(TYPE) == SaltType.SALT ? 2 : 1;
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (state.func_177229_b(TYPE) == SaltType.SALT && salt != null) {
            return salt;
        }
        return MistItems.SALTPETER;
    }

    @Override
    public int func_149745_a(Random random) {
        return 1 + random.nextInt(3);
    }

    @Override
    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        return MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
    }

    @Override
    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(TYPE) == SaltType.SALT && salt == null) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)SaltType.NORMAL));
        }
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return state.func_177229_b(TYPE) == SaltType.SALT ? EnumPushReaction.BLOCK : EnumPushReaction.NORMAL;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        if (Mist.saltymod) {
            list.add((Object)new ItemStack((Block)this, 1, 1));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((SaltType)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)SaltType.values()[meta]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177229_b(TYPE) == SaltType.SALT && salt == null) {
            return state.func_177226_a(TYPE, (Comparable)((Object)SaltType.NORMAL));
        }
        return state;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.func_185473_a(world, pos, state);
    }

    protected ItemStack func_180643_i(IBlockState state) {
        int i = state.func_177229_b(TYPE) == SaltType.SALT && Mist.saltymod ? 1 : 0;
        return new ItemStack((Block)this, 1, i);
    }

    public static enum SaltType implements IStringSerializable
    {
        NORMAL("normal"),
        SALT("salt");

        private final String name;

        private SaltType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

