/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.init.ModConfig;

public class MistPortalStone
extends MistBlock {
    public static final PropertyBool ISUP = PropertyBool.func_177716_a((String)"isup");
    public static final PropertyBool ISNEW = PropertyBool.func_177716_a((String)"isnew");
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.0, 0.6875, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0);
    private final boolean isWork;

    public MistPortalStone(boolean isWork) {
        super(Material.field_151576_e, MapColor.field_151670_w);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ISNEW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)));
        this.isWork = isWork;
        if (isWork) {
            this.func_149715_a(0.8f);
        }
        this.func_149711_c(10.0f);
        this.func_149752_b(1000.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        if (stack.func_77952_i() == 2) {
            tooltip.add(I18n.func_135052_a((String)"tile.mist.portal_old_down.tooltip", (Object[])new Object[0]));
        }
        if (stack.func_77952_i() == 3) {
            tooltip.add(I18n.func_135052_a((String)"tile.mist.portal_old_up.tooltip", (Object[])new Object[0]));
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        if (this.isWork) {
            if (((Boolean)blockState.func_177229_b((IProperty)ISUP)).booleanValue()) {
                return UP_AABB;
            }
            return DOWN_AABB;
        }
        return field_185505_j;
    }

    public boolean func_149662_c(IBlockState state) {
        return !this.isWork;
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.isWork;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (this.isWork) {
            boolean isUp = (Boolean)blockState.func_177229_b((IProperty)ISUP);
            return isUp ? side != EnumFacing.DOWN : side != EnumFacing.UP;
        }
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K && !ModConfig.Dimension.loadedDimBlackList.contains(world.field_73011_w.getDimension())) {
            boolean isUp = (Boolean)state.func_177229_b((IProperty)ISUP);
            BlockPos portalPos = isUp ? pos.func_177977_b() : pos.func_177984_a();
            BlockPos anotherBasePos = isUp ? pos.func_177979_c(2) : pos.func_177981_b(2);
            IBlockState anotherState = world.func_180495_p(anotherBasePos);
            if (world.func_180495_p(portalPos).func_177230_c() == Blocks.field_150340_R && anotherState.func_177230_c() == MistBlocks.PORTAL_BASE && (Boolean)anotherState.func_177229_b((IProperty)ISUP) == !isUp) {
                this.createPortal(world, portalPos);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!(world.field_72995_K || blockIn != MistBlocks.PORTAL && blockIn != Blocks.field_150350_a)) {
            world.func_175684_a(pos, state.func_177230_c(), 1);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && !ModConfig.Dimension.loadedDimBlackList.contains(world.field_73011_w.getDimension())) {
            if (!this.isWork) {
                BlockPos portalPos = pos.func_177977_b();
                BlockPos bottomPos = pos.func_177979_c(2);
                IBlockState bottomState = world.func_180495_p(bottomPos);
                if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue() && world.func_180495_p(portalPos).func_177230_c() == Blocks.field_150340_R && bottomState.func_177230_c() == MistBlocks.PORTAL_BASE && !((Boolean)bottomState.func_177229_b((IProperty)ISUP)).booleanValue()) {
                    this.createPortal(world, portalPos);
                }
            } else {
                boolean isUp = (Boolean)state.func_177229_b((IProperty)ISUP);
                Block portalBlock = world.func_180495_p(isUp ? pos.func_177977_b() : pos.func_177984_a()).func_177230_c();
                if (portalBlock == MistBlocks.PORTAL) {
                    return;
                }
                world.func_175656_a(pos, MistBlocks.PORTAL_BASE.func_176223_P().func_177226_a((IProperty)ISNEW, state.func_177229_b((IProperty)ISNEW)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(isUp)));
            }
        }
    }

    private void createPortal(World world, BlockPos pos) {
        world.func_175698_g(pos);
        world.func_72876_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 1.5f, true);
        world.func_175656_a(pos, MistBlocks.PORTAL.func_176223_P());
        world.func_175656_a(pos.func_177984_a(), MistBlocks.PORTAL_WORK.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ISNEW, world.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)ISNEW)));
        world.func_175656_a(pos.func_177977_b(), MistBlocks.PORTAL_WORK.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ISNEW, world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)ISNEW)));
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.isWork) {
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)ISNEW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)))));
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)ISNEW, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)))));
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)ISNEW, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)))));
            list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)ISNEW, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)))));
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)ISNEW) != false ? 0 : 2) | ((Boolean)state.func_177229_b((IProperty)ISUP) != false ? 1 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)ISNEW, (Comparable)Boolean.valueOf(meta >> 1 == 0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)MistBlocks.PORTAL_BASE);
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ISUP, ISNEW});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isWork ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)MistBlocks.PORTAL_BASE), 1, this.func_180651_a(state));
    }
}

