/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistPortalStone;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.common.MistTeleporter;
import ru.liahim.mist.util.PortalCoordData;

public class MistPortal
extends BlockBreakable {
    protected static final AxisAlignedBB XZ_AABB = new AxisAlignedBB(0.125, -0.6875, 0.125, 0.875, 1.6875, 0.875);

    public MistPortal() {
        super(Material.field_151567_E, false);
        this.func_149715_a(0.8125f);
        this.func_149713_g(0);
        this.func_149672_a(SoundType.field_185856_i);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return XZ_AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!entity.func_184218_aH() && !entity.func_184207_aI() && entity.func_184222_aU() && entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            if (pos.func_177958_n() == MathHelper.func_76128_c((double)entity.field_70165_t) && pos.func_177952_p() == MathHelper.func_76128_c((double)entity.field_70161_v)) {
                BlockPos immutablePos = pos.func_185334_h();
                MinecraftServer server = playerMP.func_184102_h();
                PlayerList playerList = server.func_184103_al();
                if (playerMP.field_71093_bK != Mist.getID()) {
                    playerList.transferPlayerToDimension(playerMP, Mist.getID(), (Teleporter)new MistTeleporter(server.func_71218_a(Mist.getID()), immutablePos));
                } else {
                    int dimId = PortalCoordData.get(world).getDim(Mist.getID(), immutablePos);
                    playerList.transferPlayerToDimension(playerMP, dimId, (Teleporter)new MistTeleporter(server.func_71218_a(dimId), immutablePos));
                }
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K && blockIn == MistBlocks.PORTAL_WORK) {
            world.func_175684_a(pos, state.func_177230_c(), 1);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            IBlockState up = world.func_180495_p(pos.func_177984_a());
            IBlockState down = world.func_180495_p(pos.func_177977_b());
            if (up.func_177230_c() != MistBlocks.PORTAL_WORK || !((Boolean)up.func_177229_b((IProperty)MistPortalStone.ISUP)).booleanValue() || down.func_177230_c() != MistBlocks.PORTAL_WORK || ((Boolean)down.func_177229_b((IProperty)MistPortalStone.ISUP)).booleanValue()) {
                world.func_175698_g(pos);
            }
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return ItemStack.field_190927_a;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        PortalCoordData.get(world).removeCoords(world.field_73011_w.getDimension(), pos);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return side != EnumFacing.UP && side != EnumFacing.DOWN;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_151660_b;
    }
}

