/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlockMossy;

public class MistMasonry
extends MistBlockMossy {
    public static final PropertyEnum<Connection> CONNECTION = PropertyEnum.func_177709_a((String)"connect", Connection.class);

    public MistMasonry() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONNECTION, (Comparable)((Object)Connection.COMMON)).func_177226_a((IProperty)VARIANT, (Comparable)((Object)MistBlockMossy.EnumType.NORMAL)));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        for (int i = 0; i < 2; ++i) {
            drops.add((Object)new ItemStack(MistItems.ROCKS));
            drops.add((Object)new ItemStack(MistItems.BRICK));
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int count = 0;
        EnumFacing dir = null;
        for (EnumFacing face : EnumFacing.field_176754_o) {
            if (!this.isMasonry(world.func_180495_p(pos.func_177972_a(face)))) continue;
            if (++count > 2) {
                return state.func_177226_a(CONNECTION, (Comparable)((Object)Connection.COMMON));
            }
            if (dir == null) {
                dir = face;
            } else if (dir == face.func_176734_d()) {
                return state.func_177226_a(CONNECTION, (Comparable)((Object)Connection.COMMON));
            }
            if (count != 2 || face != EnumFacing.EAST || dir != EnumFacing.SOUTH) continue;
            dir = EnumFacing.EAST;
        }
        return state.func_177226_a(CONNECTION, (Comparable)((Object)Connection.values()[count == 0 ? 9 : (--count << 2 | dir.func_176736_b()) + 1]));
    }

    protected boolean isMasonry(IBlockState state) {
        return state.func_177230_c() == this || state.func_177230_c() == MistBlocks.COBBLESTONE;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONNECTION, VARIANT});
    }

    public static enum Connection implements IStringSerializable
    {
        COMMON("common"),
        SOUTH("s"),
        WEST("w"),
        NORTH("n"),
        EAST("e"),
        SOUTH_WEST("sw"),
        WEST_NORTH("wn"),
        NORTH_EAST("ne"),
        EAST_SOUTH("es"),
        SINGLE("single");

        private final String name;

        private Connection(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

