/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.init.BlockColoring;

public class MistLeaves
extends BlockLeaves
implements IColoredBlock {
    public static final PropertyDirection DIR = PropertyDirection.func_177714_a((String)"dir");
    private final int baseColor;
    private final boolean mixColor;
    protected MistTreeTrunk trunkBlock;
    public final int bloomMonth;
    public final int spoilMonth;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                int baseColor = ((MistLeaves)state.func_177230_c()).getBaseColor();
                return world != null && pos != null ? (tintIndex == 0 ? ((MistLeaves)state.func_177230_c()).getMixColor(world, pos) : -1) : baseColor;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistLeaves(int baseColor, boolean mixColor, int bloomMonth, int spoilMonth) {
        this.baseColor = baseColor;
        this.mixColor = mixColor;
        this.bloomMonth = bloomMonth;
        this.spoilMonth = spoilMonth;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.DOWN));
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (placer instanceof EntityPlayer && ((EntityPlayer)placer).func_184812_l_() && facing != EnumFacing.DOWN && world.func_180495_p(pos.func_177972_a(facing.func_176734_d())).func_177230_c() == this.trunkBlock) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)facing);
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)DIR, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)DIR)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)DIR)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIR});
    }

    public void setTrunkBlock(MistTreeTrunk trunkBlock) {
        this.trunkBlock = trunkBlock;
    }

    public Block getTrunkBlock() {
        return this.trunkBlock;
    }

    private int getBaseColor() {
        return this.baseColor;
    }

    private int getMixColor(IBlockAccess world, BlockPos pos) {
        if (this.mixColor) {
            int biomeColor = BiomeColorHelper.func_180287_b((IBlockAccess)world, (BlockPos)pos);
            int r = ((biomeColor >> 16 & 0xFF) + (this.baseColor >> 16 & 0xFF) * 2) / 3;
            int g = ((biomeColor >> 8 & 0xFF) + (this.baseColor >> 8 & 0xFF) * 2) / 3;
            int b = ((biomeColor & 0xFF) + (this.baseColor & 0xFF) * 2) / 3;
            return r << 16 | g << 8 | b;
        }
        return this.baseColor;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        EnumFacing dir;
        if (!world.field_72995_K && (dir = (EnumFacing)state.func_177229_b((IProperty)DIR)) != EnumFacing.DOWN && world.func_180495_p(pos.func_177972_a(dir.func_176734_d())).func_177230_c() != this.trunkBlock) {
            world.func_175698_g(pos);
        }
    }

    public void updateLeaves(World world, BlockPos pos, IBlockState state, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((Block)this));
        return ret;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return null;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }
}

