/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IFarmland;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.block.MistHumus_Dirt;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.util.SoilHelper;

public class MistHumus_Grass
extends MistHumus_Dirt
implements IColoredBlock {
    public static final PropertyBool SNOWY = BlockGrass.field_176498_a;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistHumus_Grass(float hardness, int waterPerm) {
        super(hardness, waterPerm);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        Block block = worldIn.func_180495_p(pos.func_177984_a()).func_177230_c();
        return state.func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(block == Blocks.field_150433_aE || block == Blocks.field_150431_aC));
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            boolean change = false;
            IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
            if (stateUp.func_177230_c().isNormalCube(stateUp, (IBlockAccess)world, pos.func_177984_a()) || world.func_175671_l(pos.func_177984_a()) < 4 && stateUp.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
                change = world.func_180501_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)), 2);
            }
            if (!change) {
                super.func_180650_b(world, pos, state, rand);
            }
        }
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        IBlockState stateUp;
        boolean change = false;
        if (!(!(waterType.getY() >= 0.0f) || rand.nextInt(5 - this.getWaterPerm(state)) != 0 || (stateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof MistTreeTrunk && ((MistTreeTrunk)stateUp.func_177230_c()).getDir(stateUp) == EnumFacing.UP || waterType.getY() != 0.0f && MistDirt.getMinHumusLevel(world, pos) >= 4)) {
            change = world.func_180501_a(pos, MistBlocks.GRASS_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)MistGrass.GROWTH, (Comparable)Boolean.valueOf(false)), 2);
        }
        if (!change && rand.nextInt(4) == 0 && world.func_175671_l(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (pos1.func_177956_o() >= 0 && pos1.func_177956_o() < 256 && !world.func_175667_e(pos1)) continue;
                IBlockState state1 = world.func_180495_p(pos1);
                IBlockState state1Up = world.func_180495_p(pos1.func_177984_a());
                if (state1Up.func_177230_c().isNormalCube(state1Up, (IBlockAccess)world, pos1.func_177984_a()) || world.func_175671_l(pos1.func_177984_a()) < 4 || state1Up.getLightOpacity((IBlockAccess)world, pos1.func_177984_a()) > 2 || state1.func_177230_c() instanceof MistGrass || state1.func_177230_c() instanceof IFarmland || !(state1.func_177230_c() instanceof MistSoil) || !((Boolean)state1.func_177229_b((IProperty)WET)).booleanValue()) continue;
                SoilHelper.setGrass(world, pos1, state1, true, false, 2);
            }
        }
        return change;
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getSoilBlock().func_180660_a(state, rand, fortune);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WET, SNOWY});
    }
}

