/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeTrunk;

public class MistHumus_Dirt
extends MistSoil {
    public MistHumus_Dirt(Material material, float hardness, int waterPerm) {
        super(material, hardness, waterPerm);
    }

    public MistHumus_Dirt(float hardness, int waterPerm) {
        super(Material.field_151578_c, hardness, waterPerm);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"tile.mist.soil_hum.tooltip", (Object[])new Object[0]) + ": 10%");
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        IBlockState stateUp;
        if (!(!(waterType.getY() >= 0.0f) || rand.nextInt(5 - this.getWaterPerm(state)) != 0 || (stateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof MistTreeTrunk && ((MistTreeTrunk)stateUp.func_177230_c()).getDir(stateUp) == EnumFacing.UP || waterType.getY() != 0.0f && MistDirt.getMinHumusLevel(world, pos) >= 4)) {
            return world.func_180501_a(pos, MistBlocks.DIRT_F.func_176223_P().func_177226_a((IProperty)MistDirt.HUMUS, (Comparable)Integer.valueOf(3)), 2);
        }
        return false;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? MistItems.HUMUS : Item.func_150898_a((Block)this.getSoilBlock());
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? 4 : 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : super.func_180651_a(state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_193568_T;
    }
}

