/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IRubberBallCollideble;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.entity.EntityRubberBall;
import ru.liahim.mist.world.MistWorld;

public class MistGravel
extends BlockFalling
implements IRubberBallCollideble {
    public MistGravel() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.6f);
        this.setHarvestLevel("shovel", 0);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        if (fortune > 3) {
            fortune = 3;
        }
        if (rand.nextInt(20 - fortune * 5) == 0) {
            ret.add((Object)new ItemStack(Items.field_151145_ak));
        } else {
            int j = rand.nextInt(96);
            boolean drop = true;
            if (j < 6) {
                ret.add((Object)new ItemStack(MistItems.ROCKS, Math.max(1, rand.nextInt(8) - 5)));
                drop = false;
            } else if (j < 8 + fortune * 4 && world instanceof World) {
                if (MistWorld.isPosInFog((World)world, pos.func_177981_b(4))) {
                    if (j < 2 + fortune * 4 && rand.nextInt(10 - fortune * 3) == 0) {
                        ret.add((Object)new ItemStack(rand.nextBoolean() ? Items.field_151074_bl : MistItems.NIOBIUM_NUGGET));
                        drop = false;
                    }
                } else if (j < 7) {
                    ret.add((Object)new ItemStack(Items.field_151103_aS));
                    drop = false;
                } else if (rand.nextInt(10 - fortune * 3) == 0) {
                    ret.add((Object)new ItemStack(Items.field_191525_da));
                    drop = false;
                }
            }
            if (drop) {
                int count = this.quantityDropped(state, fortune, rand);
                for (int i = 0; i < count; ++i) {
                    Item item = this.func_180660_a(state, rand, fortune);
                    if (item == null) continue;
                    ret.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
                }
            }
        }
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        if (entity.field_70173_aa % 10 == 0 && world.field_73012_v.nextInt(3) == 0 && world.func_175623_d(pos.func_177977_b())) {
            world.func_184133_a(null, pos, SoundEvents.field_187581_bW, SoundCategory.BLOCKS, 0.3f, 1.0f);
            world.func_175684_a(pos, (Block)this, 0);
        }
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.field_151665_m;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_189876_x(IBlockState state) {
        return -8878206;
    }

    @Override
    public boolean isCollide(World world, IBlockState state, EntityRubberBall ball, RayTraceResult result, Random rand) {
        world.func_175684_a(result.func_178782_a(), (Block)this, 0);
        return true;
    }
}

