/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.biome.MistBiomes;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IFarmland;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.MistDirt;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMist;

public class MistGrass
extends MistDirt
implements IColoredBlock,
IGrowable {
    public static final PropertyBool GROWTH = PropertyBool.func_177716_a((String)"growth");
    public static final PropertyBool SNOWY = BlockGrass.field_176498_a;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistGrass(float hardness, int waterPerm) {
        super(Material.field_151577_b, hardness, waterPerm);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HUMUS, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
        return state.func_177226_a((IProperty)SNOWY, (Comparable)Boolean.valueOf(block == Blocks.field_150433_aE || block == Blocks.field_150431_aC));
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (MistWorld.canPlayAmbiendSounds(world, pos)) {
                long tick;
                Biome biome = world.func_180494_b(pos);
                long time = world.func_72820_D();
                if (biome == MistBiomes.upMeadow) {
                    long tick2 = (time + 23000L) % 24000L;
                    if (tick2 < 10000L && rand.nextInt(5 + (int)Math.abs(tick2 - 5000L) / 50) == 0) {
                        world.func_184133_a(null, pos, MistSounds.BLOCK_FOREST_HOPPER, SoundCategory.AMBIENT, 0.75f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
                    }
                } else if (biome == MistBiomes.upSavanna) {
                    long tick3 = time % 24000L;
                    if (tick3 > 12000L && rand.nextInt(5 + (int)Math.abs(tick3 - 18000L) / 50) == 0) {
                        world.func_184133_a(null, pos, MistSounds.BLOCK_DESERT_CRICKET, SoundCategory.AMBIENT, world.field_73012_v.nextFloat() * 0.2f + 0.6f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    }
                } else if (biome instanceof BiomeMist && ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Jungle && ((tick = time % 24000L) > 12000L && rand.nextInt(10 + (int)Math.abs(tick - 18000L) / 20) == 0 || rand.nextInt(50) == 0)) {
                    world.func_184133_a(null, pos, MistSounds.BLOCK_TROPIC_HOPPER, SoundCategory.AMBIENT, world.field_73012_v.nextFloat() * 1.0f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
                }
            }
            boolean change = false;
            IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
            if (world.func_175671_l(pos.func_177984_a()) < 4 && stateUp.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
                change = (Boolean)state.func_177229_b((IProperty)GROWTH) != false ? world.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(false)), 2) : world.func_180501_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)HUMUS, state.func_177229_b((IProperty)HUMUS)).func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)), 2);
            }
            if (!change) {
                super.func_180650_b(world, pos, state, rand);
            }
        }
    }

    @Override
    public EnumFacing checkAir(World world, BlockPos pos, Random rand) {
        EnumFacing face = EnumFacing.field_176754_o[rand.nextInt(4)];
        BlockPos checkPos = pos.func_177972_a(face);
        if (!world.isSideSolid(checkPos, face.func_176734_d()) && !world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) {
            return face;
        }
        return EnumFacing.DOWN;
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        if (!super.doIfWet(world, pos, state, waterType, fog, rand) && rand.nextInt(4) == 0 && world.func_175671_l(pos.func_177984_a()) >= 9) {
            if (((Boolean)state.func_177229_b((IProperty)GROWTH)).booleanValue()) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                    if (pos1.func_177956_o() >= 0 && pos1.func_177956_o() < 256 && !world.func_175667_e(pos1)) continue;
                    IBlockState state1 = world.func_180495_p(pos1);
                    IBlockState state1Up = world.func_180495_p(pos1.func_177984_a());
                    if (world.func_175671_l(pos1.func_177984_a()) < 4 || state1Up.getLightOpacity((IBlockAccess)world, pos1.func_177984_a()) > 2 || state1.func_177230_c() instanceof MistGrass || state1.func_177230_c() instanceof IFarmland || !(state1.func_177230_c() instanceof MistSoil) || !((Boolean)state1.func_177229_b((IProperty)WET)).booleanValue()) continue;
                    SoilHelper.setGrass(world, pos1, state1, true, false, 2);
                }
            } else {
                return world.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
        return false;
    }

    @Override
    public boolean doIfDry(World world, BlockPos pos, IBlockState state, boolean lava, Random rand) {
        if (rand.nextInt(16) == 0 && ((Boolean)state.func_177229_b((IProperty)GROWTH)).booleanValue() && (lava || MistWorld.getHumi(world, pos.func_177984_a(), 0.0f) < 5.0f)) {
            return world.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(false)), 2);
        }
        return false;
    }

    @Override
    public boolean setAcid(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        if (waterDist < 0 && ((Boolean)state.func_177229_b((IProperty)GROWTH)).booleanValue()) {
            return world.func_180501_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(false)), 2);
        }
        return world.func_180501_a(pos, this.getAcidBlock(state).func_176223_P().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)), 2);
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getSoilBlock());
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state) % (this.getHumSize() * 2);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)HUMUS) + ((Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : this.getHumSize()) + ((Boolean)state.func_177229_b((IProperty)GROWTH) != false ? 0 : this.getHumSize() * 2);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HUMUS, (Comparable)Integer.valueOf(meta % this.getHumSize())).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(meta % (this.getHumSize() * 2) < this.getHumSize())).func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(meta < this.getHumSize() * 2));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HUMUS, WET, GROWTH, SNOWY});
    }

    @Override
    public int getTopProtectPercent(IBlockState state, boolean isWet) {
        if (((Boolean)state.func_177229_b((IProperty)GROWTH)).booleanValue()) {
            return isWet ? 30 : 120;
        }
        return super.getTopProtectPercent(state, isWet);
    }

    @Override
    public int getSideProtectPercent(IBlockState state, boolean isWet) {
        return super.getTopProtectPercent(state, isWet);
    }

    @Override
    public int getCloseProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 30 : 120;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return (Boolean)state.func_177229_b((IProperty)GROWTH) != false;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false && (Boolean)state.func_177229_b((IProperty)GROWTH) != false && SoilHelper.getHumus(state) > 0;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World world, Random rand, BlockPos posIn, IBlockState state) {
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos pos = posIn.func_177984_a();
            int j = 0;
            while (true) {
                IBlockState checkState;
                if (j >= i / 16) {
                    if (!world.func_175623_d(pos)) continue block0;
                    if (rand.nextInt(8) == 0) {
                        world.func_180494_b(pos).plantFlower(world, rand, pos);
                        continue block0;
                    }
                    checkState = Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS);
                    if (!Blocks.field_150329_H.func_180671_f(world, pos, checkState)) continue block0;
                    world.func_175656_a(pos, checkState);
                    if (rand.nextInt(6) <= 2) continue block0;
                    checkState = world.func_180495_p(pos.func_177977_b());
                    SoilHelper.setSoil(world, pos.func_177977_b(), checkState, SoilHelper.getHumus(checkState) - 1, 2);
                    continue block0;
                }
                checkState = world.func_180495_p((pos = pos.func_177982_a(rand.nextInt(3) - 1, (rand.nextInt(3) - 1) * rand.nextInt(3) / 2, rand.nextInt(3) - 1)).func_177977_b());
                if ((!(checkState.func_177230_c() instanceof MistGrass) || !((Boolean)checkState.func_177229_b((IProperty)WET)).booleanValue() || !((Boolean)checkState.func_177229_b((IProperty)GROWTH)).booleanValue() || SoilHelper.getHumus(checkState) == 0) && checkState.func_177230_c() != Blocks.field_150349_c || world.func_180495_p(pos).func_185915_l()) continue block0;
                ++j;
            }
        }
    }
}

