/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.entity.IMatWalkable;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.MistBlockWettable;
import ru.liahim.mist.block.gizmos.MistCompostHeap;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.util.FacingHelper;

public class MistFloatingMat
extends MistBlockWettable
implements IColoredBlock {
    public static final PropertyBool GROWTH = PropertyBool.func_177716_a((String)"growth");
    protected static final AxisAlignedBB MAT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0);
    protected static final AxisAlignedBB MAT_AABB_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistFloatingMat() {
        super(Material.field_151577_b, 2);
        this.func_149672_a(SoundType.field_185859_l);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(true)));
        this.func_149711_c(0.7f);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        long tick;
        if (!world.field_72995_K && (tick = world.func_72820_D() % 24000L) > 12000L && rand.nextInt(2 + (int)Math.abs(tick - 18000L) / 250) == 0) {
            world.func_184133_a(null, pos, MistSounds.BLOCK_SWAMP_FROG, SoundCategory.AMBIENT, 0.5f, world.field_73012_v.nextFloat() * 0.3f + 0.7f);
        }
        super.func_180650_b(world, pos, state, rand);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean par_7) {
        if (!(entity instanceof IMatWalkable) && entity instanceof EntityLivingBase && entity.field_70130_N * entity.field_70130_N * entity.field_70131_O > 0.512f) {
            MistFloatingMat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)Block.field_185506_k);
        } else {
            MistFloatingMat.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)MAT_AABB);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)GROWTH) != false ? field_185505_j : MAT_AABB_BOX;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)GROWTH) != false ? 0 : 1;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(meta == 0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WET, GROWTH});
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof IMatWalkable) {
            return;
        }
        if (entity.field_70163_u < (double)pos.func_177956_o() + 0.875 && entity instanceof EntityLivingBase && entity.field_70130_N * entity.field_70130_N * entity.field_70131_O > 0.512f) {
            entity.func_70110_aj();
            if (entity.field_70167_r < entity.field_70163_u) {
                entity.field_70163_u = entity.field_70167_r;
            }
        } else {
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        entity.func_180430_e(fallDistance, 0.5f);
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState checkState = world.func_180495_p(pos.func_177972_a(side));
                Block block = checkState.func_177230_c();
                return !checkState.func_185914_p() && block != MistBlocks.FLOATING_MAT;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        switch (face) {
            case UP: {
                return false;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState faceState = world.func_180495_p(pos.func_177972_a(face));
                Block block = faceState.func_177230_c();
                return faceState.func_185904_a().func_76224_d();
            }
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (this.canSilkHarvest(world, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.func_180643_i(state));
            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack is : items) {
                MistFloatingMat.func_180635_a((World)world, (BlockPos)pos, (ItemStack)is);
            }
        } else {
            if (world.field_73011_w.func_177500_n()) {
                world.func_175698_g(pos);
                return;
            }
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.harvesters.set(player);
            this.func_176226_b(world, pos, state, i);
            this.harvesters.set(null);
            if (!this.canFlow(world, pos)) {
                world.func_175656_a(pos, Blocks.field_150358_i.func_176223_P());
            }
        }
    }

    private boolean canFlow(World world, BlockPos pos) {
        boolean check = false;
        for (EnumFacing face : FacingHelper.NOTUP) {
            Material material = world.func_180495_p(pos.func_177972_a(face)).func_185904_a();
            if (material.func_76230_c() || material.func_76224_d()) continue;
            check = true;
            break;
        }
        return check;
    }

    @Override
    public boolean setDry(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            return world.func_180501_a(pos, MistBlocks.COMPOST_HEAP.func_176223_P().func_177226_a((IProperty)MistCompostHeap.WORK, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)MistCompostHeap.STAGE, (Comparable)Integer.valueOf(rand.nextInt(3) + 2)), 3);
        }
        return world.func_175655_b(pos, true);
    }

    @Override
    public boolean setAcid(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        return world.func_175655_b(pos, true);
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        if (fog) {
            world.func_175655_b(pos, true);
        } else if (!((Boolean)state.func_177229_b((IProperty)GROWTH)).booleanValue() && world.field_73012_v.nextInt(4) == 0 && world.func_175671_l(pos.func_177984_a()) >= 9) {
            return world.func_175656_a(pos, state.func_177226_a((IProperty)GROWTH, (Comparable)Boolean.valueOf(true)));
        }
        return false;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Plains: 
            case Cave: {
                return true;
            }
            case Beach: {
                return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int count = this.quantityDropped(state, fortune, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_180660_a(state, rand, fortune);
            if (item == null) continue;
            ret.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
        }
        if (count < 3 && rand.nextInt(3 + count * 2) == 0) {
            ret.add((Object)new ItemStack(Items.field_151055_y));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? MistItems.COMPOST : Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? rand.nextInt(3) + 1 : 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getTopProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 30 : 120;
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, (Boolean)state.func_177229_b((IProperty)GROWTH) != false ? 0 : 1);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state));
    }
}

