/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IMistAdsorbent;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.world.MistWorld;

public class MistFilterCoalBlock
extends MistBlock
implements IMistAdsorbent {
    public static final PropertyInteger POLLUTE = PropertyInteger.func_177719_a((String)"pollute", (int)0, (int)15);

    public MistFilterCoalBlock() {
        super(Material.field_151576_e, MapColor.field_151646_E);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POLLUTE, (Comparable)Integer.valueOf(0)));
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149675_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        float pollute = (float)((Integer)this.func_176203_a(stack.func_77952_i()).func_177229_b((IProperty)POLLUTE)).intValue() * 6.25f;
        StringBuilder sb = new StringBuilder();
        sb.append(I18n.func_135052_a((String)"item.mist.filter_damage.tooltip", (Object[])new Object[0]));
        sb.append(": ");
        if (pollute >= 25.0f) {
            sb.append(pollute < 50.0f ? TextFormatting.YELLOW : (pollute < 75.0f ? TextFormatting.GOLD : TextFormatting.RED));
        }
        sb.append(String.format("%.2f", Float.valueOf(pollute)));
        sb.append("%");
        tooltip.add(sb.toString());
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && rand.nextInt(4) == 0 && MistWorld.isPosInFog(world, pos)) {
            int pollute = (Integer)state.func_177229_b((IProperty)POLLUTE);
            if (pollute < 15) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)POLLUTE, (Comparable)Integer.valueOf(pollute + 1)));
            } else {
                world.func_175655_b(pos, false);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 4));
        list.add((Object)new ItemStack((Block)this, 1, 8));
        list.add((Object)new ItemStack((Block)this, 1, 12));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POLLUTE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POLLUTE, (Comparable)Integer.valueOf(meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POLLUTE});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public boolean isMistAdsorbent(World world, BlockPos pos, IBlockState state) {
        return true;
    }
}

