/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IFarmland;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistHumus_Dirt;

public class MistFarmland_H
extends MistHumus_Dirt
implements IFarmland {
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    public MistFarmland_H(float hardness, int waterPerm) {
        super(Material.field_151578_c, hardness, waterPerm);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)MULCH, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(255);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)MULCH) != false ? field_185505_j : FARMLAND_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)MULCH);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)MULCH);
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        IBlockState state;
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < fallDistance - 0.5f && entity instanceof EntityLivingBase && (entity instanceof EntityPlayer || world.func_82736_K().func_82766_b("mobGriefing")) && entity.field_70130_N * entity.field_70130_N * entity.field_70131_O > 0.512f && !((Boolean)(state = world.func_180495_p(pos)).func_177229_b((IProperty)MULCH)).booleanValue()) {
            world.func_175656_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)));
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean change = false;
        if (rand.nextInt(50) == 0 && !((Boolean)state.func_177229_b((IProperty)MULCH)).booleanValue()) {
            Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
            boolean bl = change = !(block instanceof IPlantable) || !this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, (IPlantable)block);
        }
        if (change) {
            world.func_175656_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)));
        } else {
            super.func_180650_b(world, pos, state, rand);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        super.func_189540_a(state, world, pos, block, fromPos);
        Material upMat = world.func_180495_p(pos.func_177984_a()).func_185904_a();
        if (upMat.func_76220_a()) {
            if (!((Boolean)state.func_177229_b((IProperty)MULCH)).booleanValue()) {
                world.func_175656_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)));
            }
        } else if (upMat.func_76224_d()) {
            if (((Boolean)state.func_177229_b((IProperty)MULCH)).booleanValue()) {
                Block.func_180635_a((World)world, (BlockPos)pos.func_177984_a(), (ItemStack)new ItemStack(MistItems.MULCH));
            }
            world.func_175656_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)));
        }
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            return MistItems.HUMUS;
        }
        return Item.func_150898_a((Block)this.getSoilBlock());
    }

    @Override
    public int quantityDropped(IBlockState state, int fortune, Random random) {
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            return 4;
        }
        return 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            return 0;
        }
        return this.func_176201_c(state) % 2;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        super.getDrops(drops, world, pos, state, fortune);
        if (((Boolean)state.func_177229_b((IProperty)MULCH)).booleanValue()) {
            drops.add((Object)new ItemStack(MistItems.MULCH));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    @Override
    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        switch (plantType) {
            case Plains: 
            case Cave: 
            case Crop: {
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState checkState = world.func_180495_p(pos.func_177972_a(side));
                Block block = checkState.func_177230_c();
                return !checkState.func_185914_p() && block != Blocks.field_150458_ak && block != Blocks.field_185774_da && !(block instanceof IFarmland) && block != MistBlocks.FLOATING_MAT;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        switch (face) {
            case UP: {
                return false;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState faceState = world.func_180495_p(pos.func_177972_a(face));
                Block block = faceState.func_177230_c();
                return faceState.func_185904_a().func_76224_d();
            }
        }
        return false;
    }

    public boolean isFertile(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return (Boolean)state.func_177229_b((IProperty)WET);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)MULCH) != false ? 1 : 0) << 1 | ((Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : 1);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)MULCH, (Comparable)Boolean.valueOf(meta > 1));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MULCH, WET});
    }

    @Override
    public int getTopProtectPercent(IBlockState state, boolean isWet) {
        if (((Boolean)state.func_177229_b((IProperty)MULCH)).booleanValue()) {
            return isWet ? 10 : 140;
        }
        return super.getTopProtectPercent(state, isWet);
    }

    @Override
    public int getCloseProtectPercent(IBlockState state, boolean isWet) {
        if (((Boolean)state.func_177229_b((IProperty)MULCH)).booleanValue()) {
            return isWet ? 10 : 140;
        }
        return super.getCloseProtectPercent(state, isWet);
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.getSoilBlock(), 1, this.func_180651_a(state));
    }
}

