/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.util.SoilHelper;

public class MistDirt
extends MistSoil {
    public static final PropertyInteger HUMUS = PropertyInteger.func_177719_a((String)"humus", (int)0, (int)3);
    private final MapColor color;

    public MistDirt(Material material, float hardness, int waterPerm, MapColor color) {
        super(material, hardness, waterPerm);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HUMUS, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
        this.color = color;
    }

    public MistDirt(Material material, float hardness, int waterPerm) {
        this(material, hardness, waterPerm, material.func_151565_r());
    }

    public MistDirt(float hardness, int waterPerm) {
        this(Material.field_151578_c, hardness, waterPerm, Material.field_151578_c.func_151565_r());
    }

    public MistDirt(float hardness, int waterPerm, MapColor color) {
        this(Material.field_151578_c, hardness, waterPerm, color);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"tile.mist.soil_hum.tooltip", (Object[])new Object[0]) + ": " + ((Integer)this.func_176203_a(stack.func_77952_i()).func_177229_b((IProperty)HUMUS) + 1) * 2 + "%");
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        int hum;
        IBlockState stateUp;
        int waterDist = (int)waterType.getY();
        if (!(waterDist < 0 || rand.nextInt(5 - this.getWaterPerm(state)) != 0 || (stateUp = world.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof MistTreeTrunk && ((MistTreeTrunk)stateUp.func_177230_c()).getDir(stateUp) == EnumFacing.UP || (hum = ((Integer)state.func_177229_b((IProperty)HUMUS)).intValue()) <= waterDist + 3 - this.getWaterPerm(state) || waterDist != 0 && hum <= MistDirt.getMinHumusLevel(world, pos))) {
            return world.func_180501_a(pos, state.func_177226_a((IProperty)HUMUS, (Comparable)Integer.valueOf(hum - 1)), 2);
        }
        return false;
    }

    public static int getMinHumusLevel(World world, BlockPos pos) {
        int i = 4;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos checkPos;
            if (face == EnumFacing.DOWN || !world.func_175667_e(checkPos = pos.func_177972_a(face)) || !(world.func_180495_p(checkPos).func_177230_c() instanceof MistSoil)) continue;
            IBlockState checkState = world.func_180495_p(checkPos);
            i = Math.min(i, SoilHelper.getHumus(checkState));
        }
        return i;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 4));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        Integer hum = (Integer)state.func_177229_b((IProperty)HUMUS);
        return hum + ((Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : this.getHumSize());
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HUMUS, (Comparable)Integer.valueOf(meta % this.getHumSize())).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(meta < this.getHumSize()));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HUMUS, WET});
    }

    public boolean canFertile(IBlockState state) {
        return false;
    }

    protected final int getHumSize() {
        return HUMUS.func_177700_c().size();
    }

    @Override
    public IBlockState getFarmState(IBlockState state) {
        return this.getFarmBlock().func_176223_P().func_177226_a((IProperty)HUMUS, state.func_177229_b((IProperty)HUMUS)).func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET));
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.color;
    }
}

