/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlockWettable;
import ru.liahim.mist.entity.EntityDesertFish;

public class MistClay
extends MistBlockWettable {
    public static final PropertyEnum<EnumClayType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumClayType.class);
    public static final PropertyEnum<EnumBlockType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumBlockType.class);

    public MistClay() {
        super(Material.field_151571_B, 1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumClayType.CLAY)).func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE)).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
        this.func_149711_c(1.5f);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean showPorosityTooltip() {
        return false;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? SoundType.field_185849_b : SoundType.field_185851_d;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        Material upMat;
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() && state.func_177229_b(TYPE) == EnumBlockType.CRACKED && ((upMat = world.func_180495_p(pos.func_177984_a()).func_185904_a()).func_76220_a() || upMat.func_76224_d())) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE));
        }
        return state;
    }

    @Override
    public boolean setWet(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        if (state.func_177229_b(TYPE) == EnumBlockType.CONTAINER) {
            world.func_175655_b(pos, false);
            return true;
        }
        return super.setWet(world, pos, state, waterDist, rand);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (state.func_177229_b(TYPE) == EnumBlockType.CONTAINER) {
            EntityDesertFish.spawnFish(world, pos, world.field_73012_v);
        }
        super.func_180663_b(world, pos, state);
    }

    @Override
    public int getTopProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 40 : 120;
    }

    public void func_180658_a(World world, BlockPos pos, Entity entity, float fallDistance) {
        IBlockState state;
        if (!world.field_72995_K && world.field_73012_v.nextFloat() < fallDistance - 0.5f && entity instanceof EntityLivingBase && (entity instanceof EntityPlayer || world.func_82736_K().func_82766_b("mobGriefing")) && entity.field_70130_N * entity.field_70130_N * entity.field_70131_O > 0.512f && ((Boolean)(state = world.func_180495_p(pos)).func_177229_b((IProperty)WET)).booleanValue() && state.func_177229_b(TYPE) == EnumBlockType.CRACKED) {
            world.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE)), 2);
        }
        super.func_180658_a(world, pos, entity, fallDistance);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        Material upMat;
        super.func_189540_a(state, world, pos, block, fromPos);
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() && state.func_177229_b(TYPE) == EnumBlockType.CRACKED && ((upMat = world.func_180495_p(pos.func_177984_a()).func_185904_a()).func_76220_a() || upMat.func_76224_d())) {
            world.func_180501_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE)), 2);
        }
    }

    @Override
    public boolean setDry(World world, BlockPos pos, IBlockState state, Random rand) {
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        if (!(stateUp.func_177230_c() instanceof IWettable) || !((Boolean)stateUp.func_177229_b((IProperty)WET)).booleanValue()) {
            if (state.func_177229_b(TYPE) == EnumBlockType.BLOCK) {
                return world.func_180501_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)), 2);
            }
            return world.func_180501_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)).func_177226_a(TYPE, (Comparable)((Object)(stateUp.isSideSolid((IBlockAccess)world, pos.func_177984_a(), EnumFacing.DOWN) ? EnumBlockType.NATURE : EnumBlockType.CRACKED))), 2);
        }
        return false;
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (state.func_177229_b(TYPE) != EnumBlockType.CONTAINER) {
            int i;
            Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
            int count = this.quantityDropped(state, fortune, rand);
            for (i = 0; i < count; ++i) {
                Item item = this.func_180660_a(state, rand, fortune);
                if (item == null) continue;
                ret.add((Object)new ItemStack(item, 1, this.func_180651_a(state)));
            }
            if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() && count < 4 && state.func_177229_b(TYPE) != EnumBlockType.BLOCK) {
                i = rand.nextInt(8 + count * 4);
                if (i < 2) {
                    ret.add((Object)new ItemStack(MistItems.ROCKS));
                } else if (i == 2) {
                    ret.add((Object)new ItemStack(Items.field_151055_y));
                } else if (i < 3 + fortune && rand.nextInt(Math.max(1, 4 - fortune)) == 0) {
                    ret.add((Object)new ItemStack(Items.field_151044_h, 1, 1));
                }
            }
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? MistItems.CLAY_BALL : Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return ((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() ? (state.func_177229_b(TYPE) == EnumBlockType.BLOCK ? 4 : 2 + random.nextInt(3)) : 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() ? (state.func_177229_b(VARIANT) == EnumClayType.CLAY ? 0 : 1) : this.func_176201_c(state);
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        int i;
        for (i = 0; i < 6; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
        for (i = 8; i < 14; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumClayType)((Object)state.func_177229_b(VARIANT))).getMetadata() << 3 | ((EnumBlockType)((Object)state.func_177229_b(TYPE))).getMetadata() << 1 | ((Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : 1);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)(meta < 8 ? EnumClayType.CLAY : EnumClayType.RED_CLAY))).func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.byMetadata(meta / 2 & 3))).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf((meta & 1) == 0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, WET, TYPE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b(TYPE) == EnumBlockType.CONTAINER ? state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE)) : state;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (state.func_177229_b(TYPE) == EnumBlockType.CONTAINER) {
            state = state.func_177226_a(TYPE, (Comparable)((Object)EnumBlockType.NATURE));
        }
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    public static enum EnumBlockType implements IStringSerializable
    {
        BLOCK(0, "block"),
        NATURE(1, "nature"),
        CRACKED(2, "cracked"),
        CONTAINER(3, "container");

        private static final EnumBlockType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumBlockType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumBlockType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumBlockType[EnumBlockType.values().length];
            EnumBlockType[] enumBlockTypeArray = EnumBlockType.values();
            int n = enumBlockTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumBlockType type;
                EnumBlockType.META_LOOKUP[type.getMetadata()] = type = enumBlockTypeArray[i];
            }
        }
    }

    public static enum EnumClayType implements IStringSerializable
    {
        CLAY(0, "clay_gray", MapColor.field_151667_k),
        RED_CLAY(1, "clay_red", MapColor.field_193559_aa);

        private static final EnumClayType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor mapColor;

        private EnumClayType(int meta, String name, MapColor mapColor) {
            this.meta = meta;
            this.name = name;
            this.mapColor = mapColor;
        }

        public int getMetadata() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.mapColor;
        }

        public static EnumClayType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumClayType[EnumClayType.values().length];
            EnumClayType[] enumClayTypeArray = EnumClayType.values();
            int n = enumClayTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumClayType type;
                EnumClayType.META_LOOKUP[type.getMetadata()] = type = enumClayTypeArray[i];
            }
        }
    }
}

