/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IRubberBallCollideble;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.entity.EntityRubberBall;

public class MistBlockWettableFalling
extends BlockFalling
implements IWettable,
IRubberBallCollideble {
    private final int waterPerm;
    private Block acidBlock;

    public MistBlockWettableFalling(Material material, int waterPerm) {
        super(material);
        this.waterPerm = MathHelper.func_76125_a((int)waterPerm, (int)1, (int)3);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
        this.func_149675_a(true);
        this.acidBlock = this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        IBlockState state = this.func_176203_a(stack.func_77952_i());
        String gender = I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[0]);
        gender = gender.length() > 2 && gender.substring(gender.length() - 2, gender.length() - 1).equals("_") ? gender.substring(gender.length() - 2, gender.length()) : "";
        tooltip.add(I18n.func_135052_a((String)((Boolean)state.func_177229_b((IProperty)WET) != false ? "tile.mist.block_wet" + gender + ".tooltip" : "tile.mist.block_dry" + gender + ".tooltip"), (Object[])new Object[0]));
        if (this.showPorosityTooltip()) {
            tooltip.add(I18n.func_135052_a((String)("tile.mist.soil_porosity_" + this.waterPerm + gender + ".tooltip"), (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean showPorosityTooltip() {
        return true;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int i = IWettable.checkFluid(world, pos);
            if (i < 0) {
                this.setAcid(world, pos, state, 0, world.field_73012_v);
            } else if (i > 0 && !((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
                this.setWet(world, pos, state, 0, world.field_73012_v);
            }
        }
        if ((state = world.func_180495_p(pos)).func_177230_c() instanceof IWettable) {
            this.checkFallable(world, pos, state, world.field_73012_v);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState checkState = world.func_180495_p(fromPos);
        if (checkState.func_177230_c() == MistBlocks.ACID_BLOCK) {
            this.setAcid(world, pos, state, 0, world.field_73012_v);
        } else if (checkState.func_185904_a() == Material.field_151586_h && !((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            this.setWet(world, pos, state, 0, world.field_73012_v);
        }
        state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof IWettable) {
            this.checkFallable(world, pos, state, world.field_73012_v);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.update(world, pos, state, rand) && (state = world.func_180495_p(pos)).func_177230_c() instanceof IWettable) {
            this.checkFallable(world, pos, state, rand);
        }
    }

    protected void checkFallable(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.canFall(world, pos, state, rand)) {
            int i = 32;
            if (!field_149832_M && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, state);
                    this.func_149829_a(entityfallingblock);
                    world.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((world.func_175623_d(blockpos) || MistBlockWettableFalling.func_185759_i((IBlockState)world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    protected boolean canFall(World world, BlockPos pos, IBlockState state, Random rand) {
        return !(!world.func_175623_d(pos.func_177977_b()) && !MistBlockWettableFalling.func_185759_i((IBlockState)world.func_180495_p(pos.func_177977_b())) || pos.func_177956_o() < 0 || (Boolean)state.func_177229_b((IProperty)WET) != false && rand.nextInt(8) != 0 && !this.checkNeighbor(world, pos));
    }

    protected boolean checkNeighbor(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            BlockPos checkPos = pos.func_177972_a(side);
            IBlockState state = world.func_180495_p(checkPos);
            if (!state.isSideSolid((IBlockAccess)world, pos, side.func_176734_d())) continue;
            if (state.func_177230_c() instanceof BlockFalling) {
                if (!(state.func_177230_c() instanceof IWettable) || !((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() || world.func_175623_d(checkPos.func_177977_b()) || MistBlockWettableFalling.func_185759_i((IBlockState)world.func_180495_p(checkPos.func_177977_b()))) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean setDry(World world, BlockPos pos, IBlockState state, Random rand) {
        return world.func_175656_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (!((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() && rand.nextInt(16) == 0 && MistBlockWettableFalling.func_185759_i((IBlockState)world.func_180495_p(blockpos = pos.func_177977_b()))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(meta == 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WET});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public int getWaterPerm(IBlockState state) {
        return this.waterPerm;
    }

    @Override
    public void setAcidBlock(Block acidBlock) {
        this.acidBlock = acidBlock;
    }

    @Override
    public Block getAcidBlock(IBlockState state) {
        return this.acidBlock;
    }

    @Override
    public boolean isAcid() {
        return false;
    }

    @Override
    public boolean isCollide(World world, IBlockState state, EntityRubberBall ball, RayTraceResult result, Random rand) {
        this.checkFallable(world, result.func_178782_a(), state, rand);
        return true;
    }
}

