/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlock;

public class MistBlockWettable
extends MistBlock
implements IWettable {
    private final int waterPerm;
    private Block acidBlock;

    public MistBlockWettable(Material material, int waterPerm) {
        super(material);
        this.waterPerm = MathHelper.func_76125_a((int)waterPerm, (int)1, (int)3);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)));
        this.func_149675_a(true);
        this.acidBlock = this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        String gender = I18n.func_135052_a((String)(stack.func_77977_a() + ".name"), (Object[])new Object[0]);
        gender = gender.length() > 2 && gender.substring(gender.length() - 2, gender.length() - 1).equals("_") ? gender.substring(gender.length() - 2, gender.length()) : "";
        IBlockState state = this.func_176203_a(stack.func_77952_i());
        tooltip.add(I18n.func_135052_a((String)((Boolean)state.func_177229_b((IProperty)WET) != false ? "tile.mist.block_wet" + gender + ".tooltip" : "tile.mist.block_dry" + gender + ".tooltip"), (Object[])new Object[0]));
        if (this.showPorosityTooltip()) {
            tooltip.add(I18n.func_135052_a((String)("tile.mist.soil_porosity_" + this.getWaterPerm(state) + gender + ".tooltip"), (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected boolean showPorosityTooltip() {
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState checkState = world.func_180495_p(fromPos);
        if (checkState.func_177230_c() == MistBlocks.ACID_BLOCK) {
            this.setAcid(world, pos, state, 0, world.field_73012_v);
        } else if (checkState.func_185904_a() == Material.field_151586_h && !((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            this.setWet(world, pos, state, 0, world.field_73012_v);
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            int i = IWettable.checkFluid(world, pos);
            if (i < 0) {
                this.setAcid(world, pos, state, 0, world.field_73012_v);
            } else if (i > 0 && !((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
                this.setWet(world, pos, state, 0, world.field_73012_v);
            }
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.update(world, pos, state, rand);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : 1;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(meta == 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{WET});
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @Override
    public int getWaterPerm(IBlockState state) {
        return this.waterPerm;
    }

    @Override
    public void setAcidBlock(Block acidBlock) {
        this.acidBlock = acidBlock;
    }

    @Override
    public Block getAcidBlock(IBlockState state) {
        return this.acidBlock;
    }

    @Override
    public boolean isAcid() {
        return false;
    }
}

