/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockStep;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.world.MistWorld;

public class MistBlockWall
extends MistBlockStep {
    protected static final AxisAlignedBB AABB_QTR_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_EAST = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_QTR_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_QTR_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_NW = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_NE = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 0.5);
    protected static final AxisAlignedBB AABB_OCT_SW = new AxisAlignedBB(0.0, 0.0, 0.5, 0.5, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_OCT_SE = new AxisAlignedBB(0.5, 0.0, 0.5, 1.0, 1.0, 1.0);

    public MistBlockWall(IBlockState modelState, boolean tick) {
        super(modelState, tick);
    }

    public MistBlockWall(IBlockState modelState) {
        this(modelState, false);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)this.func_176221_a(state, source, pos).func_177229_b((IProperty)field_176310_M);
        if (shape == BlockStairs.EnumShape.STRAIGHT) {
            return MistBlockWall.getCollQuarterBlock(state);
        }
        if (shape == BlockStairs.EnumShape.OUTER_LEFT || shape == BlockStairs.EnumShape.OUTER_RIGHT) {
            return MistBlockWall.getCollEighthBlock(state);
        }
        return field_185505_j;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean par7) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        for (AxisAlignedBB axisalignedbb : MistBlockWall.getCollisionBoxList(state)) {
            MistBlockWall.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)bstate.func_177229_b((IProperty)field_176310_M);
        if (shape == BlockStairs.EnumShape.STRAIGHT || shape == BlockStairs.EnumShape.INNER_LEFT || shape == BlockStairs.EnumShape.INNER_RIGHT) {
            list.add(MistBlockWall.getCollQuarterBlock(bstate));
        }
        if (shape != BlockStairs.EnumShape.STRAIGHT) {
            list.add(MistBlockWall.getCollEighthBlock(bstate));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState bstate) {
        switch ((EnumFacing)bstate.func_177229_b((IProperty)field_176309_a)) {
            default: {
                return AABB_QTR_NORTH;
            }
            case SOUTH: {
                return AABB_QTR_SOUTH;
            }
            case WEST: {
                return AABB_QTR_WEST;
            }
            case EAST: 
        }
        return AABB_QTR_EAST;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState bstate) {
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)bstate.func_177229_b((IProperty)field_176309_a);
        switch ((BlockStairs.EnumShape)bstate.func_177229_b((IProperty)field_176310_M)) {
            default: {
                enumfacing1 = enumfacing;
                break;
            }
            case OUTER_RIGHT: {
                enumfacing1 = enumfacing.func_176746_e();
                break;
            }
            case INNER_RIGHT: {
                enumfacing1 = enumfacing.func_176734_d();
                break;
            }
            case INNER_LEFT: {
                enumfacing1 = enumfacing.func_176735_f();
            }
        }
        switch (enumfacing1) {
            default: {
                return AABB_OCT_NW;
            }
            case SOUTH: {
                return AABB_OCT_SE;
            }
            case WEST: {
                return AABB_OCT_SW;
            }
            case EAST: 
        }
        return AABB_OCT_NE;
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            float i = 1.0f - hitZ;
            state = state.func_177226_a((IProperty)field_176309_a, (Comparable)(hitX < hitZ ? (hitX < i ? EnumFacing.WEST : EnumFacing.SOUTH) : (hitX < i ? EnumFacing.NORTH : EnumFacing.EAST)));
        } else {
            state = facing == EnumFacing.EAST || facing == EnumFacing.WEST ? state.func_177226_a((IProperty)field_176309_a, (Comparable)((double)hitZ < 0.25 ? EnumFacing.NORTH : ((double)hitZ < 0.75 ? facing.func_176734_d() : EnumFacing.SOUTH))) : state.func_177226_a((IProperty)field_176309_a, (Comparable)((double)hitX < 0.25 ? EnumFacing.WEST : ((double)hitX < 0.75 ? facing.func_176734_d() : EnumFacing.EAST)));
        }
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a((IProperty)field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : state.func_177226_a((IProperty)field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
    }

    @Override
    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : MistBlockWall.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.tick && !world.field_72995_K) {
            if (this.isMossBlock()) {
                if (rand.nextInt(4) == 0 && MistWorld.isPosInFog(world, pos.func_177956_o())) {
                    world.func_175656_a(pos, this.func_176223_P());
                }
            } else if (this.isNormalBlock() && rand.nextInt(500) == 0 && !MistWorld.isPosInFog(world, pos.func_177956_o()) && world.func_180494_b(pos).func_76727_i() >= 0.3f) {
                EnumFacing[] faces = EnumFacing.field_176754_o;
                EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)field_176309_a);
                for (EnumFacing side : faces) {
                    if (side == face.func_176734_d() || world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                    return;
                }
                boolean check = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistGrass;
                if (!check && !world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (!(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (!check) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (world.isSideSolid(pos.func_177972_a(side), side.func_176734_d()) || !(world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (check) {
                    world.func_175656_a(pos, this.getMossBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, (Comparable)face).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                }
            }
        }
    }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.tick && !world.field_72995_K && this.isMossBlock()) {
            EnumFacing[] faces = EnumFacing.field_176754_o;
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)field_176309_a);
            for (EnumFacing side : faces) {
                if (side == face.func_176734_d() || world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.getNormalBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, (Comparable)face).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                break;
            }
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.tick && !world.field_72995_K && this.isMossBlock()) {
            EnumFacing[] faces = EnumFacing.field_176754_o;
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)field_176309_a);
            for (EnumFacing side : faces) {
                if (side == face.func_176734_d() || world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.getNormalBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, (Comparable)face).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                break;
            }
        }
    }

    @Override
    protected Block getNormalBlock() {
        if (this == MistBlocks.COBBLESTONE_MOSS_WALL) {
            return MistBlocks.COBBLESTONE_WALL;
        }
        if (this == MistBlocks.STONE_BRICK_MOSS_WALL) {
            return MistBlocks.STONE_BRICK_WALL;
        }
        return this;
    }

    @Override
    protected Block getMossBlock() {
        if (this == MistBlocks.COBBLESTONE_WALL) {
            return MistBlocks.COBBLESTONE_MOSS_WALL;
        }
        if (this == MistBlocks.STONE_BRICK_WALL) {
            return MistBlocks.STONE_BRICK_MOSS_WALL;
        }
        return this;
    }

    @Override
    protected boolean isNormalBlock() {
        return this == MistBlocks.COBBLESTONE_WALL || this == MistBlocks.STONE_BRICK_WALL;
    }

    @Override
    protected boolean isMossBlock() {
        return this == MistBlocks.COBBLESTONE_MOSS_WALL || this == MistBlocks.STONE_BRICK_MOSS_WALL;
    }

    @Override
    public boolean setMossy(IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() == MistBlocks.COBBLESTONE_WALL) {
            return world.func_175656_a(pos, MistBlocks.COBBLESTONE_MOSS_WALL.func_176223_P().func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)));
        }
        if (state.func_177230_c() == MistBlocks.STONE_BRICK_WALL) {
            return world.func_175656_a(pos, MistBlocks.STONE_BRICK_MOSS_WALL.func_176223_P().func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)));
        }
        return false;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == state.func_177229_b((IProperty)field_176309_a) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Override
    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getStepBlock(state).func_180660_a(state, rand, fortune);
    }

    @Override
    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }
}

