/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IDividable;
import ru.liahim.mist.api.block.IMossable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public class MistBlockStep
extends BlockStairs
implements IDividable,
IMossable {
    private final Block fullBlock;
    protected final boolean tick;

    public MistBlockStep(IBlockState modelState, boolean tick) {
        super(modelState);
        this.field_149783_u = true;
        this.func_149713_g(0);
        this.fullBlock = modelState.func_177230_c();
        this.tick = tick;
        this.func_149675_a(tick);
    }

    public MistBlockStep(IBlockState modelState) {
        this(modelState, false);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return this.func_176221_a(state, (IBlockAccess)worldIn, pos).func_185900_c((IBlockAccess)worldIn, pos).func_186670_a(pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)this.func_176221_a(state, source, pos).func_177229_b((IProperty)field_176310_M);
        if (shape == BlockStairs.EnumShape.STRAIGHT) {
            return MistBlockStep.getCollQuarterBlock(state);
        }
        if (shape == BlockStairs.EnumShape.OUTER_LEFT || shape == BlockStairs.EnumShape.OUTER_RIGHT) {
            return MistBlockStep.getCollEighthBlock(state);
        }
        return state.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.TOP ? field_185719_G : field_185712_d;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean par7) {
        state = this.func_176221_a(state, (IBlockAccess)worldIn, pos);
        for (AxisAlignedBB axisalignedbb : MistBlockStep.getCollisionBoxList(state)) {
            MistBlockStep.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState bstate) {
        ArrayList list = Lists.newArrayList();
        BlockStairs.EnumShape shape = (BlockStairs.EnumShape)bstate.func_177229_b((IProperty)field_176310_M);
        if (shape == BlockStairs.EnumShape.STRAIGHT || shape == BlockStairs.EnumShape.INNER_LEFT || shape == BlockStairs.EnumShape.INNER_RIGHT) {
            list.add(MistBlockStep.getCollQuarterBlock(bstate));
        }
        if (shape != BlockStairs.EnumShape.STRAIGHT) {
            list.add(MistBlockStep.getCollEighthBlock(bstate));
        }
        return list;
    }

    private static AxisAlignedBB getCollQuarterBlock(IBlockState bstate) {
        boolean flag = bstate.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.TOP;
        switch ((EnumFacing)bstate.func_177229_b((IProperty)field_176309_a)) {
            default: {
                return flag ? field_185722_J : field_185718_g;
            }
            case SOUTH: {
                return flag ? field_185723_K : field_185710_B;
            }
            case WEST: {
                return flag ? field_185720_H : field_185714_e;
            }
            case EAST: 
        }
        return flag ? field_185721_I : field_185716_f;
    }

    private static AxisAlignedBB getCollEighthBlock(IBlockState bstate) {
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)bstate.func_177229_b((IProperty)field_176309_a);
        switch ((BlockStairs.EnumShape)bstate.func_177229_b((IProperty)field_176310_M)) {
            default: {
                enumfacing1 = enumfacing;
                break;
            }
            case OUTER_RIGHT: {
                enumfacing1 = enumfacing.func_176746_e();
                break;
            }
            case INNER_RIGHT: {
                enumfacing1 = enumfacing.func_176734_d();
                break;
            }
            case INNER_LEFT: {
                enumfacing1 = enumfacing.func_176735_f();
            }
        }
        boolean flag = bstate.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.TOP;
        switch (enumfacing1) {
            default: {
                return flag ? field_185724_L : field_185711_C;
            }
            case SOUTH: {
                return flag ? field_185727_O : field_185717_F;
            }
            case WEST: {
                return flag ? field_185726_N : field_185715_E;
            }
            case EAST: 
        }
        return flag ? field_185725_M : field_185713_D;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)field_176310_M, (Comparable)BlockStairs.EnumShape.STRAIGHT);
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            float i = 1.0f - hitZ;
            state = state.func_177226_a((IProperty)field_176309_a, (Comparable)(hitX < hitZ ? (hitX < i ? EnumFacing.WEST : EnumFacing.SOUTH) : (hitX < i ? EnumFacing.NORTH : EnumFacing.EAST)));
        } else {
            state = facing == EnumFacing.EAST || facing == EnumFacing.WEST ? state.func_177226_a((IProperty)field_176309_a, (Comparable)((double)hitZ < 0.33 ? EnumFacing.NORTH : ((double)hitZ < 0.66 ? facing.func_176734_d() : EnumFacing.SOUTH))) : state.func_177226_a((IProperty)field_176309_a, (Comparable)((double)hitX < 0.33 ? EnumFacing.WEST : ((double)hitX < 0.66 ? facing.func_176734_d() : EnumFacing.EAST)));
        }
        return facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state.func_177226_a((IProperty)field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP) : state.func_177226_a((IProperty)field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM);
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : MistBlockStep.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)worldIn, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult raytraceresult1 = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            raytraceresult1 = raytraceresult;
            d1 = d0;
        }
        return raytraceresult1;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.tick && !world.field_72995_K) {
            if (this.isMossBlock()) {
                if (rand.nextInt(4) == 0 && MistWorld.isPosInFog(world, pos.func_177956_o())) {
                    world.func_175656_a(pos, this.func_176223_P());
                }
            } else if (this.isNormalBlock() && rand.nextInt(500) == 0 && !MistWorld.isPosInFog(world, pos.func_177956_o()) && world.func_180494_b(pos).func_76727_i() >= 0.3f) {
                boolean check;
                boolean up = state.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.BOTTOM;
                EnumFacing[] faces = up ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o;
                EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)field_176309_a);
                for (EnumFacing side : faces) {
                    if (side == face.func_176734_d() || world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                    return;
                }
                boolean bl = check = !up && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistGrass;
                if (!check && !world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (!(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (!up && !check) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (world.isSideSolid(pos.func_177972_a(side), side.func_176734_d()) || !(world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (check) {
                    world.func_175656_a(pos, this.getMossBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, (Comparable)face).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                }
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.tick && !world.field_72995_K && this.isMossBlock()) {
            EnumFacing[] faces = state.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.BOTTOM ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o;
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)field_176309_a);
            for (EnumFacing side : faces) {
                if (side == face.func_176734_d() || world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.getNormalBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, (Comparable)face).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                break;
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.tick && !world.field_72995_K && this.isMossBlock()) {
            EnumFacing[] faces = state.func_177229_b((IProperty)field_176308_b) == BlockStairs.EnumHalf.BOTTOM ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o;
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)field_176309_a);
            for (EnumFacing side : faces) {
                if (side == face.func_176734_d() || world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.getNormalBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, (Comparable)face).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                break;
            }
        }
    }

    protected Block getNormalBlock() {
        if (this == MistBlocks.COBBLESTONE_MOSS_STEP) {
            return MistBlocks.COBBLESTONE_STEP;
        }
        if (this == MistBlocks.STONE_BRICK_MOSS_STEP) {
            return MistBlocks.STONE_BRICK_STEP;
        }
        return this;
    }

    protected Block getMossBlock() {
        if (this == MistBlocks.COBBLESTONE_STEP) {
            return MistBlocks.COBBLESTONE_MOSS_STEP;
        }
        if (this == MistBlocks.STONE_BRICK_STEP) {
            return MistBlocks.STONE_BRICK_MOSS_STEP;
        }
        return this;
    }

    protected boolean isNormalBlock() {
        return this == MistBlocks.COBBLESTONE_STEP || this == MistBlocks.STONE_BRICK_STEP;
    }

    protected boolean isMossBlock() {
        return this == MistBlocks.COBBLESTONE_MOSS_STEP || this == MistBlocks.STONE_BRICK_MOSS_STEP;
    }

    @Override
    public boolean setMossy(IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() == MistBlocks.COBBLESTONE_STEP) {
            return world.func_175656_a(pos, MistBlocks.COBBLESTONE_MOSS_STEP.func_176223_P().func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)));
        }
        if (state.func_177230_c() == MistBlocks.STONE_BRICK_STEP) {
            return world.func_175656_a(pos, MistBlocks.STONE_BRICK_MOSS_STEP.func_176223_P().func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)));
        }
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this == MistBlocks.COBBLESTONE_STEP || this == MistBlocks.COBBLESTONE_MOSS_STEP) {
            return MistItems.ROCKS;
        }
        if (this == MistBlocks.STONE_BRICK_STEP || this == MistBlocks.STONE_BRICK_MOSS_STEP) {
            return MistItems.BRICK;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    @Override
    public Block getFullBlock() {
        return this.fullBlock;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fullBlock.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fullBlock.getFireSpreadSpeed(world, pos, face);
    }
}

