/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IDividable;
import ru.liahim.mist.api.block.IMossable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public class MistBlockStairs
extends BlockStairs
implements IDividable,
IMossable {
    private final Block full_Block;
    private final boolean tick;

    public MistBlockStairs(IBlockState modelState, boolean tick) {
        super(modelState);
        this.field_149783_u = true;
        this.full_Block = modelState.func_177230_c();
        this.tick = tick;
        this.func_149675_a(tick);
    }

    public MistBlockStairs(IBlockState modelState) {
        this(modelState, false);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    @Override
    public Block getFullBlock() {
        return this.full_Block;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.tick && !world.field_72995_K) {
            if (this.isMossBlock()) {
                if (rand.nextInt(4) == 0 && MistWorld.isPosInFog(world, pos.func_177956_o())) {
                    world.func_175656_a(pos, this.func_176223_P());
                }
            } else if (this.isNormalBlock() && rand.nextInt(500) == 0 && !MistWorld.isPosInFog(world, pos.func_177956_o()) && world.func_180494_b(pos).func_76727_i() >= 0.3f) {
                boolean check;
                for (EnumFacing side : FacingHelper.NOTDOWN) {
                    if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                    return;
                }
                boolean bl = check = state.func_177229_b((IProperty)field_176308_b) != BlockStairs.EnumHalf.BOTTOM && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistGrass;
                if (!check && !world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (!(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (!check) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (world.isSideSolid(pos.func_177972_a(side), side.func_176734_d()) || !(world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (check) {
                    world.func_175656_a(pos, this.getMossBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                }
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (this.tick && !world.field_72995_K && this.isMossBlock()) {
            for (EnumFacing side : FacingHelper.NOTDOWN) {
                if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.getNormalBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                break;
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (this.tick && !world.field_72995_K && this.isMossBlock()) {
            for (EnumFacing side : FacingHelper.NOTDOWN) {
                if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.getNormalBlock().func_176223_P().func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)).func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176310_M, state.func_177229_b((IProperty)field_176310_M)));
                break;
            }
        }
    }

    protected Block getNormalBlock() {
        if (this == MistBlocks.COBBLESTONE_MOSS_STAIRS) {
            return MistBlocks.COBBLESTONE_STAIRS;
        }
        if (this == MistBlocks.STONE_BRICK_MOSS_STAIRS) {
            return MistBlocks.STONE_BRICK_STAIRS;
        }
        return this;
    }

    protected Block getMossBlock() {
        if (this == MistBlocks.COBBLESTONE_STAIRS) {
            return MistBlocks.COBBLESTONE_MOSS_STAIRS;
        }
        if (this == MistBlocks.STONE_BRICK_STAIRS) {
            return MistBlocks.STONE_BRICK_MOSS_STAIRS;
        }
        return this;
    }

    protected boolean isNormalBlock() {
        return this == MistBlocks.COBBLESTONE_STAIRS || this == MistBlocks.STONE_BRICK_STAIRS;
    }

    protected boolean isMossBlock() {
        return this == MistBlocks.COBBLESTONE_MOSS_STAIRS || this == MistBlocks.STONE_BRICK_MOSS_STAIRS;
    }

    @Override
    public boolean setMossy(IBlockState state, World world, BlockPos pos) {
        if (state.func_177230_c() == MistBlocks.COBBLESTONE_STAIRS) {
            return world.func_175656_a(pos, MistBlocks.COBBLESTONE_MOSS_STAIRS.func_176223_P().func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)));
        }
        if (state.func_177230_c() == MistBlocks.STONE_BRICK_STAIRS) {
            return world.func_175656_a(pos, MistBlocks.STONE_BRICK_MOSS_STAIRS.func_176223_P().func_177226_a((IProperty)field_176308_b, state.func_177229_b((IProperty)field_176308_b)).func_177226_a((IProperty)field_176309_a, state.func_177229_b((IProperty)field_176309_a)));
        }
        return false;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 3;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getStepBlock(state).func_180660_a(state, rand, fortune);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.full_Block.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.full_Block.getFireSpreadSpeed(world, pos, face);
    }
}

