/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IDividable;
import ru.liahim.mist.api.block.IMossable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockSlab;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public class MistBlockSlabStone
extends MistBlockSlab
implements IDividable,
IColoredBlock,
IMossable {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistBlockSlabStone(Block fullBlock, float hardness, float resistance) {
        super(fullBlock, Material.field_151576_e, hardness, resistance);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)));
        this.func_149675_a(true);
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
        return this.func_176552_j() ? state : (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state : state.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (state.func_177229_b(VARIANT) == EnumType.MOSSY) {
                if (rand.nextInt(4) == 0 && MistWorld.isPosInFog(world, pos.func_177956_o())) {
                    world.func_175656_a(pos, this.func_176223_P());
                }
            } else if (rand.nextInt(500) == 0 && !MistWorld.isPosInFog(world, pos.func_177956_o()) && world.func_180494_b(pos).func_76727_i() >= 0.3f) {
                EnumFacing[] faces;
                boolean up = state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP;
                for (EnumFacing side : faces = up ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o) {
                    if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                    return;
                }
                boolean check = false;
                if (!world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (!(world.func_180495_p(pos.func_177972_a(side)).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (!up && !check) {
                    for (EnumFacing side : EnumFacing.field_176754_o) {
                        if (world.isSideSolid(pos.func_177972_a(side), side.func_176734_d()) || !(world.func_180495_p(pos.func_177972_a(side).func_177977_b()).func_177230_c() instanceof MistGrass)) continue;
                        check = true;
                        break;
                    }
                }
                if (check) {
                    world.func_175656_a(pos, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.MOSSY)).func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a)));
                }
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing[] faces;
            for (EnumFacing side : faces = state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o) {
                if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)).func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a)));
                break;
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            EnumFacing[] faces;
            for (EnumFacing side : faces = state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? FacingHelper.NOTDOWN : EnumFacing.field_176754_o) {
                if (world.func_180495_p(pos.func_177972_a(side)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                world.func_175656_a(pos, this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)).func_177226_a((IProperty)field_176554_a, state.func_177229_b((IProperty)field_176554_a)));
                break;
            }
        }
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta % 8))).func_177226_a((IProperty)field_176554_a, (Comparable)(meta < 8 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0) | ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 0));
        list.add((Object)new ItemStack((Block)this, 1, 1));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata());
    }

    @Override
    public boolean setMossy(IBlockState state, World world, BlockPos pos) {
        if (!(state.func_177230_c() instanceof IMossable) || state.func_177229_b(VARIANT) == EnumType.MOSSY) {
            return false;
        }
        return world.func_175656_a(pos, state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.MOSSY)));
    }

    public static enum EnumType implements IStringSerializable
    {
        NORMAL(0, "normal"),
        MOSSY(1, "moss");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

