/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IDividable;
import ru.liahim.mist.block.MistBlockSlabWood;

public class MistBlockSlab
extends BlockSlab
implements IDividable {
    private final Block fullBlock;

    public MistBlockSlab(Block fullBlock, Material material, float hardness, float resistance) {
        super(material);
        this.func_149711_c(hardness);
        if (resistance > 0.0f) {
            this.func_149752_b(resistance);
        }
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM));
        this.field_149783_u = true;
        this.fullBlock = fullBlock;
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176223_P();
        return this.func_176552_j() ? state : (facing != EnumFacing.DOWN && (facing == EnumFacing.UP || (double)hitY <= 0.5) ? state : state.func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 2;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getStepBlock(state).func_180660_a(state, rand, fortune);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
    }

    public int func_176201_c(IBlockState state) {
        return state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP ? 8 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a});
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    @Override
    public Block getFullBlock() {
        return this.fullBlock;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fullBlock.getFlammability(world, pos, face);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fullBlock.getFireSpreadSpeed(world, pos, face);
    }

    public static IBlockState getClearSlabState(IBlockState state) {
        if ((state = state.func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM)).func_177230_c() instanceof MistBlockSlabWood) {
            state = state.func_177226_a((IProperty)MistBlockSlabWood.ISROT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public String func_150002_b(int meta) {
        return null;
    }

    public boolean func_176552_j() {
        return false;
    }

    public IProperty<?> func_176551_l() {
        return null;
    }

    public Comparable<?> func_185674_a(ItemStack stack) {
        return null;
    }
}

