/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockWall;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IMossable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public class MistBlockFenceStone
extends BlockWall
implements IColoredBlock,
IMossable {
    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistBlockFenceStone(Block modelBlock) {
        super(modelBlock);
        this.func_149675_a(true);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (state.func_177229_b((IProperty)field_176255_P) == BlockWall.EnumType.MOSSY) {
                if (rand.nextInt(4) == 0 && MistWorld.isPosInFog(world, pos.func_177956_o())) {
                    world.func_175656_a(pos, this.func_176223_P());
                }
            } else if (rand.nextInt(500) == 0 && !MistWorld.isPosInFog(world, pos.func_177956_o()) && world.func_180494_b(pos).func_76727_i() >= 0.3f) {
                for (EnumFacing face : FacingHelper.NOTDOWN) {
                    if (world.func_180495_p(pos.func_177972_a(face)).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
                    return;
                }
                if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistGrass) {
                    world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)field_176255_P, (Comparable)BlockWall.EnumType.MOSSY));
                }
            }
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (this == MistBlocks.COBBLESTONE_FENCE) {
            return MistItems.ROCKS;
        }
        if (this == MistBlocks.STONE_BRICK_FENCE) {
            return MistItems.BRICK;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int func_149745_a(Random random) {
        return 6;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((BlockWall.EnumType)state.func_177229_b((IProperty)field_176255_P)).func_176657_a());
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return state.func_177229_b((IProperty)field_176255_P) == BlockWall.EnumType.MOSSY ? layer == BlockRenderLayer.CUTOUT_MIPPED : layer == BlockRenderLayer.SOLID;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean setMossy(IBlockState state, World world, BlockPos pos) {
        if (!(state.func_177230_c() instanceof IMossable) || state.func_177229_b((IProperty)field_176255_P) == BlockWall.EnumType.MOSSY) {
            return false;
        }
        return world.func_175656_a(pos, state.func_177226_a((IProperty)field_176255_P, (Comparable)BlockWall.EnumType.MOSSY));
    }
}

