/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemLead;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.block.MistBlockBranch;

public class MistBlockFence
extends BlockFence {
    public static final PropertyInteger SIZE = MistBlockBranch.SIZE;
    public static final PropertyBool DEBARKING = MistBlockBranch.DEBARKING;
    private final int flammability;
    private final int fireSpeed;
    public static final AxisAlignedBB BIG_PILLAR_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.5, 0.75);
    protected static final AxisAlignedBB[] BIG_BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final Block branch;

    public MistBlockFence(Block branch, float hardness, int flammability, int fireSpeed) {
        super(Material.field_151575_d, Material.field_151575_d.func_151565_r());
        this.func_149711_c(hardness);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176526_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176525_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176527_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176528_N, (Comparable)Boolean.valueOf(false)));
        this.flammability = flammability;
        this.fireSpeed = fireSpeed;
        this.branch = branch;
    }

    public MistBlockFence(Block branch, float hardness) {
        this(branch, hardness, 20, 5);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean isActualState) {
        if (!isActualState) {
            state = state.func_185899_b((IBlockAccess)world, pos);
        }
        if ((Integer)state.func_177229_b((IProperty)SIZE) == 0) {
            MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185671_f);
        } else {
            MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BIG_PILLAR_AABB);
        }
        if (!(((Boolean)state.func_177229_b((IProperty)field_176526_a)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)field_176525_b)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)field_176527_M)).booleanValue() || ((Boolean)state.func_177229_b((IProperty)field_176528_N)).booleanValue())) {
            MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185668_C);
            MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185669_D);
            MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185672_g);
            MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185667_B);
        } else {
            if (((Boolean)state.func_177229_b((IProperty)field_176526_a)).booleanValue()) {
                MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185668_C);
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176525_b)).booleanValue()) {
                MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185669_D);
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176527_M)).booleanValue()) {
                MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185672_g);
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176528_N)).booleanValue()) {
                MistBlockFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185667_B);
            }
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return (Integer)(state = this.func_176221_a(state, source, pos)).func_177229_b((IProperty)SIZE) == 0 ? field_185670_e[MistBlockFence.getBoundingBoxIdx(state)] : BIG_BOUNDING_BOXES[MistBlockFence.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)field_176526_a)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176525_b)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176527_M)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176528_N)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        if (i == 0) {
            i = 15;
        }
        return i;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(hand).func_77973_b() == Items.field_151058_ca && (Integer)state.func_177229_b((IProperty)SIZE) == 0) {
            if (!world.field_72995_K) {
                return ItemLead.func_180618_a((EntityPlayer)player, (World)world, (BlockPos)pos);
            }
            return true;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(this.branch, 1, this.func_180651_a(state) * 3));
        drops.add((Object)new ItemStack(Items.field_151055_y));
        drops.add((Object)new ItemStack(Items.field_151055_y));
    }

    public void func_149666_a(CreativeTabs item, NonNullList<ItemStack> items) {
        Iterator iterator = SIZE.func_177700_c().iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(false)))));
            items.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(true)))));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(meta >> 1)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(meta % 2 == 1));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SIZE) << 1 | ((Boolean)state.func_177229_b((IProperty)DEBARKING) != false ? 1 : 0);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SIZE, DEBARKING, field_176526_a, field_176525_b, field_176528_N, field_176527_M});
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpeed;
    }
}

