/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistBlockFence;
import ru.liahim.mist.init.ModAdvancements;

public class MistBlockBranch
extends MistBlock {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final PropertyInteger SIZE = PropertyInteger.func_177719_a((String)"size", (int)0, (int)1);
    public static final PropertyBool DEBARKING = PropertyBool.func_177716_a((String)"deb");
    public static final PropertyBool POSITIVE_CONNECTION = PropertyBool.func_177716_a((String)"positive");
    public static final PropertyBool NEGATIVE_CONNECTION = PropertyBool.func_177716_a((String)"negative");
    private final int flammability;
    private final int fireSpeed;
    private Block fence;
    protected static final AxisAlignedBB X0 = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    protected static final AxisAlignedBB Y0 = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    protected static final AxisAlignedBB Z0 = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
    protected static final AxisAlignedBB X1 = new AxisAlignedBB(0.0, 0.25, 0.25, 1.0, 0.75, 0.75);
    protected static final AxisAlignedBB Y1 = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 1.0, 0.75);
    protected static final AxisAlignedBB Z1 = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 1.0);

    public MistBlockBranch(float hardness, float resistance, int flammability, int fireSpeed, MapColor color) {
        super(Material.field_151575_d, color);
        this.func_149711_c(hardness);
        if (resistance > 0.0f) {
            this.func_149752_b(resistance);
        }
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(false)));
        this.flammability = flammability;
        this.fireSpeed = fireSpeed;
    }

    public MistBlockBranch(float hardness, float resistance, int flammability, int fireSpeed) {
        this(hardness, resistance, flammability, fireSpeed, Material.field_151575_d.func_151565_r());
    }

    public MistBlockBranch(float hardness, int flammability, int fireSpeed, MapColor color) {
        this(hardness, -1.0f, flammability, fireSpeed, color);
    }

    public MistBlockBranch(float hardness, int flammability, int fireSpeed) {
        this(hardness, -1.0f, flammability, fireSpeed, Material.field_151575_d.func_151565_r());
    }

    public MistBlockBranch(float hardness, MapColor color) {
        this(hardness, -1.0f, 20, 5, color);
    }

    public MistBlockBranch(float hardness) {
        this(hardness, -1.0f, 20, 5, Material.field_151575_d.func_151565_r());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        int size = (Integer)state.func_177229_b((IProperty)SIZE);
        if (axis == EnumFacing.Axis.X) {
            return size == 0 ? X0 : X1;
        }
        if (axis == EnumFacing.Axis.Y) {
            return size == 0 ? Y0 : Y1;
        }
        return size == 0 ? Z0 : Z1;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = this.func_176203_a(meta);
        switch (facing.func_176740_k()) {
            case Z: {
                return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
            }
            case X: {
                return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
            }
            case Y: {
                return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y);
            }
        }
        return state;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!((Boolean)state.func_177229_b((IProperty)DEBARKING)).booleanValue() && heldItem != null && heldItem.func_77973_b() instanceof ItemAxe && side.func_176740_k() != state.func_177229_b(AXIS)) {
            if (!world.field_72995_K) {
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.CARVING.trigger((EntityPlayerMP)player, world, pos, false);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(true)));
                heldItem.func_77972_a(1, (EntityLivingBase)player);
                ItemStack stack = new ItemStack(MistItems.MULCH);
                pos = pos.func_177972_a(side);
                EntityItem entity_item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                entity_item.func_174869_p();
                world.func_72838_d((Entity)entity_item);
            }
            return true;
        }
        if (heldItem.func_77973_b() == Items.field_151055_y && heldItem.func_190916_E() >= 2 && state.func_177229_b(AXIS) == EnumFacing.Axis.Y) {
            if (!world.field_72995_K) {
                world.func_175656_a(pos, this.fence.func_176223_P().func_177226_a((IProperty)SIZE, state.func_177229_b((IProperty)SIZE)).func_177226_a((IProperty)DEBARKING, state.func_177229_b((IProperty)DEBARKING)));
                if (!player.func_184812_l_()) {
                    heldItem.func_190918_g(2);
                }
            }
            SoundType soundtype = this.fence.getSoundType(this.fence.func_176223_P(), world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            return true;
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        if (state.func_177229_b(AXIS) == EnumFacing.Axis.Y) {
            return super.func_180643_i(state);
        }
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(false)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(true)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(false)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(true)))));
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.flammability;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return this.fireSpeed;
    }

    public void setFence(Block fence) {
        this.fence = fence;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149686_d(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return state.func_177229_b(AXIS) == side.func_176740_k() ? ((Integer)state.func_177229_b((IProperty)SIZE) == 0 ? BlockFaceShape.CENTER : BlockFaceShape.CENTER_BIG) : BlockFaceShape.UNDEFINED;
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("axis")) continue;
            world.func_175656_a(pos, state.func_177231_a(prop));
            return true;
        }
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
                    case X: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return state.func_177229_b(AXIS) != EnumFacing.Axis.Y;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177229_b(AXIS) == EnumFacing.Axis.Y;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        int size = (Integer)state.func_177229_b((IProperty)SIZE);
        IBlockState posState = world.func_180495_p(pos.func_177972_a(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.POSITIVE, (EnumFacing.Axis)axis)));
        IBlockState negState = world.func_180495_p(pos.func_177972_a(EnumFacing.func_181076_a((EnumFacing.AxisDirection)EnumFacing.AxisDirection.NEGATIVE, (EnumFacing.Axis)axis)));
        boolean positive = posState.func_177230_c() instanceof MistBlockBranch && posState.func_177229_b(AXIS) != axis && (Integer)posState.func_177229_b((IProperty)SIZE) >= size || posState.func_177230_c() instanceof BlockFence && axis != EnumFacing.Axis.Y && size == 0 || posState.func_177230_c() instanceof MistBlockFence && axis != EnumFacing.Axis.Y && size == 1 && (Integer)posState.func_177229_b((IProperty)SIZE) == 1;
        boolean negative = negState.func_177230_c() instanceof MistBlockBranch && negState.func_177229_b(AXIS) != axis && (Integer)negState.func_177229_b((IProperty)SIZE) >= size || negState.func_177230_c() instanceof BlockFence && axis != EnumFacing.Axis.Y && size == 0 || negState.func_177230_c() instanceof MistBlockFence && axis != EnumFacing.Axis.Y && size == 1 && (Integer)negState.func_177229_b((IProperty)SIZE) == 1;
        return state.func_177226_a((IProperty)POSITIVE_CONNECTION, (Comparable)Boolean.valueOf(positive)).func_177226_a((IProperty)NEGATIVE_CONNECTION, (Comparable)Boolean.valueOf(negative));
    }

    public IBlockState func_176203_a(int meta) {
        int i = meta % 3;
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)(i == 0 ? EnumFacing.Axis.Y : (i == 1 ? EnumFacing.Axis.X : EnumFacing.Axis.Z))).func_177226_a((IProperty)DEBARKING, (Comparable)Boolean.valueOf(meta % 6 > 2)).func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(meta / 6));
    }

    public int func_176201_c(IBlockState state) {
        EnumFacing.Axis a = (EnumFacing.Axis)state.func_177229_b(AXIS);
        return (a == EnumFacing.Axis.Y ? 0 : (a == EnumFacing.Axis.X ? 1 : 2)) + ((Boolean)state.func_177229_b((IProperty)DEBARKING) != false ? 3 : 0) + (Integer)state.func_177229_b((IProperty)SIZE) * 6;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, SIZE, DEBARKING, POSITIVE_CONNECTION, NEGATIVE_CONNECTION});
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_176201_c(state.func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y)));
    }
}

