/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.block.MistAcidDirt;
import ru.liahim.mist.block.MistAcidSoil;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.world.MistWorld;

public class MistAcidGrass
extends MistAcidDirt
implements IColoredBlock {
    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.DOWN_GRASS_COLORING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistAcidGrass(Material material, float hardness, int waterPerm) {
        super(material, hardness, waterPerm);
    }

    public MistAcidGrass(float hardness, int waterPerm) {
        super(Material.field_151577_b, hardness, waterPerm);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            boolean change = false;
            IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
            if (stateUp.func_177230_c().isNormalCube(stateUp, (IBlockAccess)world, pos.func_177984_a()) || world.func_175671_l(pos.func_177984_a()) < 4 && stateUp.getLightOpacity((IBlockAccess)world, pos.func_177984_a()) > 2) {
                change = world.func_180501_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)), 2);
            }
            if (!change) {
                super.func_180650_b(world, pos, state, rand);
            }
        }
    }

    @Override
    public EnumFacing checkAir(World world, BlockPos pos, Random rand) {
        EnumFacing face = EnumFacing.field_176754_o[rand.nextInt(4)];
        BlockPos checkPos = pos.func_177972_a(face);
        if (!world.isSideSolid(checkPos, face.func_176734_d()) && !world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) {
            return face;
        }
        return EnumFacing.DOWN;
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        if ((fog || waterType.getX() < 0.0f) && rand.nextInt(4) == 0 && world.func_175671_l(pos.func_177984_a()) >= 9) {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(5) - 3, rand.nextInt(3) - 1);
                if (pos1.func_177956_o() >= 0 && pos1.func_177956_o() < 256 && !world.func_175667_e(pos1)) continue;
                IBlockState state1 = world.func_180495_p(pos1);
                IBlockState state1Up = world.func_180495_p(pos1.func_177984_a());
                if (state1Up.func_177230_c().isNormalCube(state1Up, (IBlockAccess)world, pos1.func_177984_a()) || world.func_175671_l(pos1.func_177984_a()) < 4 || state1Up.getLightOpacity((IBlockAccess)world, pos1.func_177984_a()) > 2 || state1.func_177230_c() instanceof MistAcidGrass || !(state1.func_177230_c() instanceof MistAcidSoil) || !((Boolean)state1.func_177229_b((IProperty)WET)).booleanValue()) continue;
                world.func_180501_a(pos1, ((MistAcidSoil)state1.func_177230_c()).getGrassBlock().func_176223_P(), 2);
            }
        }
        return false;
    }

    @Override
    public boolean doIfDry(World world, BlockPos pos, IBlockState state, boolean lava, Random rand) {
        if (rand.nextInt(4) == 0 && (lava || MistWorld.getHumi(world, pos.func_177984_a(), 0.0f) < 30.0f)) {
            world.func_180501_a(pos, this.getSoilBlock().func_176223_P().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)), 2);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        super.func_180655_c(state, world, pos, rand);
        if (((Boolean)state.func_177229_b((IProperty)WET)).booleanValue() && rand.nextInt(10) == 0) {
            world.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this.getSoilBlock());
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public int getTopProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 30 : 120;
    }

    @Override
    public int getSideProtectPercent(IBlockState state, boolean isWet) {
        return super.getTopProtectPercent(state, isWet);
    }

    @Override
    public int getCloseProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 30 : 120;
    }

    @Override
    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_193571_W;
    }
}

