/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.advancement.FogDamagePredicate;
import ru.liahim.mist.api.block.IDownPlant;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.FogDamage;
import ru.liahim.mist.world.MistWorld;

public class MistAcidBlock
extends BlockFluidClassic {
    public MistAcidBlock(Fluid fluid) {
        super(fluid, Material.field_151586_h);
        this.func_149713_g(3);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity.field_70128_L) {
            return;
        }
        if (entity instanceof EntityLivingBase) {
            if (entity instanceof EntityBlaze) {
                return;
            }
            if (entity instanceof EntityMagmaCube) {
                return;
            }
            if (entity instanceof EntityPlayer && (((EntityPlayer)entity).func_184812_l_() || ((EntityPlayer)entity).func_110143_aJ() == 0.0f)) {
                return;
            }
            if (!world.field_72995_K && entity.field_70173_aa % 10 == 0) {
                float concentration = MistWorld.isPosInFog(world, pos.func_177956_o() + 2) ? FogDamage.getConcentration(world, pos) : 0.0f;
                concentration = 0.5f + concentration / 2.0f;
                float damage = FogDamage.getAcidDamage(concentration);
                float pollution = FogDamage.getAcidPollution(concentration);
                if (entity instanceof EntityPlayerMP) {
                    float[] suitFactor = FogDamage.getPollutionProtection((EntityPlayer)entity);
                    float pollutionFactor = 1.0f;
                    if (suitFactor[0] > 0.0f) {
                        pollutionFactor = (float)((double)pollutionFactor - Math.pow(FogDamage.getFinalEfficiency(suitFactor[1], concentration), 2.0));
                    }
                    damage *= pollutionFactor;
                    pollution *= pollutionFactor;
                    if (damage > 0.2f) {
                        entity.func_70097_a(MistWorld.DISSOLUTION, damage);
                        IMistCapaHandler.getHandler((EntityPlayer)entity).addPollution((int)Math.ceil(pollution));
                        ModAdvancements.FOG_DAMAGE.trigger((EntityPlayerMP)entity, entity.field_70170_p, entity.func_180425_c(), FogDamagePredicate.FogDamageType.BY_ACID, -1.0f, null, suitFactor[0] == 4.0f, null);
                    }
                } else {
                    entity.func_70097_a(MistWorld.DISSOLUTION, damage);
                }
            }
        } else if (entity instanceof EntityBoat && !entity.field_70128_L) {
            if ((entity.field_70173_aa & 1) == 0) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)pos.func_177956_o() + 1.0, (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
            if (!world.field_72995_K && entity.field_70173_aa > 200) {
                entity.func_70106_y();
                if (world.func_82736_K().func_82766_b("doEntityDrops")) {
                    for (int i = 0; i < 3; ++i) {
                        entity.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150344_f), 1, ((EntityBoat)entity).func_184453_r().func_184982_b()), 0.0f);
                    }
                    for (int j = 0; j < 2; ++j) {
                        entity.func_145778_a(Items.field_151055_y, 1, 0.0f);
                    }
                }
            }
        } else if (entity instanceof EntityFishHook && !entity.field_70128_L && entity.field_70173_aa > 30) {
            if (!world.field_72995_K) {
                entity.func_70106_y();
            }
        } else if (entity instanceof EntityItem && !entity.field_70128_L && entity.field_70173_aa > 60 && !world.field_72995_K) {
            entity.func_70106_y();
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!world.field_72995_K) {
            if (world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockBush && !(world.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof IDownPlant)) {
                world.func_175655_b(pos.func_177984_a(), true);
            }
            if (rand.nextBoolean()) {
                BlockPos pos1 = pos.func_177972_a(FacingHelper.NOTUP[rand.nextInt(5)]);
                if (this.isSoluble(world.func_180495_p(pos1).func_185904_a())) {
                    world.func_175655_b(pos1, false);
                } else if (pos1 == pos.func_177977_b() && (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150391_bh)) {
                    world.func_175656_a(pos.func_177977_b(), Blocks.field_150346_d.func_176223_P());
                }
            }
            boolean isDown = MistWorld.isPosInFog(world, pos.func_177981_b(4));
            int level = (Integer)state.func_177229_b((IProperty)LEVEL);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                IBlockState stateW = world.func_180495_p(pos.func_177972_a(face));
                if (stateW.func_177230_c() != Blocks.field_150355_j && stateW.func_177230_c() != Blocks.field_150358_i) continue;
                int levelW = (Integer)stateW.func_177229_b((IProperty)BlockLiquid.field_176367_b);
                if (isDown) {
                    if (face == EnumFacing.UP || face != EnumFacing.DOWN && levelW <= level && (levelW != 0 || level >= 2)) continue;
                    world.func_175656_a(pos.func_177972_a(face), this.func_176223_P().func_177226_a((IProperty)LEVEL, (Comparable)Integer.valueOf(levelW)));
                    continue;
                }
                if (face == EnumFacing.DOWN || face != EnumFacing.UP && levelW >= level && (level != 0 || levelW >= 2)) continue;
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level)));
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int i = rand.nextInt(5);
        if (i == 0) {
            if (this.isSoluble(world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_185904_a())) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + 1.0f), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (i == 1) {
            if (this.isSoluble(world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_185904_a())) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)pos.func_177958_n(), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (i == 2) {
            if (this.isSoluble(world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_185904_a())) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)pos.func_177952_p(), 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (i == 3) {
            if (this.isSoluble(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185904_a())) {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + 1.0f), 0.0, 0.0, 0.0, new int[0]);
            }
        } else if (i == 4 && this.isSoluble(world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185904_a())) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + 1.1f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private boolean isSoluble(Material mat) {
        if (mat == Material.field_151586_h) {
            return false;
        }
        if (mat == Material.field_151579_a) {
            return false;
        }
        if (mat == Material.field_151578_c) {
            return false;
        }
        if (mat == Material.field_151577_b) {
            return false;
        }
        if (mat == Material.field_151576_e) {
            return false;
        }
        if (mat == Material.field_151595_p) {
            return false;
        }
        if (mat == Material.field_151571_B) {
            return false;
        }
        if (mat == Material.field_151573_f) {
            return false;
        }
        if (mat == Material.field_151592_s) {
            return false;
        }
        if (mat == Material.field_151574_g) {
            return false;
        }
        return mat != Material.field_175972_I;
    }

    public float getFluidHeightForRender(IBlockAccess world, BlockPos pos, @Nonnull IBlockState up) {
        IBlockState here = world.func_180495_p(pos);
        if (here.func_177230_c() == this) {
            if (up.func_185904_a().func_76224_d()) {
                return 1.0f;
            }
            if (this.func_176201_c(here) == this.getMaxRenderHeightMeta()) {
                return 0.8888889f;
            }
        }
        if (here.func_177230_c() instanceof BlockLiquid) {
            if ((Integer)here.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 8) {
                return 1.0f;
            }
            if (up.func_185904_a().func_76224_d()) {
                return 1.0f;
            }
            return Math.min(1.0f - BlockLiquid.func_149801_b((int)((Integer)here.func_177229_b((IProperty)BlockLiquid.field_176367_b))), 0.8888889f);
        }
        return !here.func_185904_a().func_76220_a() && up.func_185904_a().func_76224_d() ? 1.0f : (here.func_177230_c() == Blocks.field_150350_a ? 0.0f : this.getQuantaPercentage(world, pos) * 8.0f / 9.0f);
    }

    public float getFluidHeightAverage(float ... flow) {
        float total = 0.0f;
        int count = 0;
        float end = 0.0f;
        for (int i = 0; i < flow.length; ++i) {
            if (flow[i] == 1.0f) {
                return 1.0f;
            }
            if (flow[i] >= 0.8888889f) {
                total += flow[i] * 10.0f;
                count += 10;
            }
            if (!(flow[i] >= 0.0f)) continue;
            total += flow[i];
            ++count;
        }
        if (end == 0.0f) {
            end = total / (float)count;
        }
        return end - 0.001f;
    }

    public boolean displaceIfPossible(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == this || block instanceof BlockLiquid) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                if (state.func_177230_c() != Blocks.field_150431_aC) {
                    block.func_176226_b(world, pos, state, 0);
                }
                return true;
            }
            return false;
        }
        Material material = state.func_185904_a();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = MistAcidBlock.getDensity((IBlockAccess)world, (BlockPos)pos);
        if (density == Integer.MAX_VALUE) {
            block.func_176226_b(world, pos, state, 0);
            return true;
        }
        return this.density > density;
    }

    public int getQuantaValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150350_a) {
            return 0;
        }
        if (state.func_177230_c() instanceof BlockLiquid) {
            return this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        }
        if (state.func_177230_c() != this) {
            return -1;
        }
        return this.quantaPerBlock - (Integer)state.func_177229_b((IProperty)LEVEL);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return MapColor.field_193566_R;
    }
}

