/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.registry;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IMistStoneBasic;
import ru.liahim.mist.api.block.IMistStoneUpper;
import ru.liahim.mist.api.block.IShiftPlaceable;
import ru.liahim.mist.api.registry.IMistHarvest;

public class MistRegistry {
    public static final Set<Item> filterCoalBreakers = Sets.newHashSet();
    public static final Map<Item, int[]> mistStoneBreakers = Maps.newHashMap();
    public static final Map<String, Integer> dimsForSkill = Maps.newHashMap();
    public static final Map<ResourceLocation, Integer> mobsForSkill = Maps.newHashMap();
    public static final Set<String> mobsDimsBlackList = Sets.newHashSet();
    public static final Set<ResourceLocation> mobsBlackList = Sets.newHashSet();
    private static final Map<Block, IMistHarvest.HarvestType> harvestTypeList = Maps.newHashMap();
    private static final Set<ItemStack> compostIngredients = Sets.newHashSet();
    private static final Set<IShiftPlaceable> shiftPlaceableBlocks = Sets.newHashSet();

    public static void registerCompostIngredient(ItemStack stack) {
        compostIngredients.add(stack);
    }

    public static void registerHarvestType(Block block, IMistHarvest.HarvestType type) {
        if (harvestTypeList.containsKey(block)) {
            harvestTypeList.replace(block, type);
        } else {
            harvestTypeList.put(block, type);
        }
    }

    public static boolean isCompostIngredient(ItemStack stack) {
        for (ItemStack compost : compostIngredients) {
            if (stack.func_77973_b() != compost.func_77973_b() || stack.func_77952_i() != compost.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static IMistHarvest.HarvestType getHarvestType(Block block) {
        return harvestTypeList.containsKey(block) ? harvestTypeList.get(block) : IMistHarvest.HarvestType.WP1_3;
    }

    public static boolean addShiftPlaceableBlocks(IShiftPlaceable block) {
        return shiftPlaceableBlocks.add(block);
    }

    public static boolean checkShiftPlacing(World world, BlockPos pos, @Nonnull ItemStack stack, EntityPlayer player, float hitX, float hitY, float hitZ, BlockFaceShape bfs) {
        for (IShiftPlaceable block : shiftPlaceableBlocks) {
            if (!block.onShiftPlacing(world, pos, stack, player, hitX, hitY, hitZ, bfs)) continue;
            return true;
        }
        return false;
    }

    public static float getBreakingSpeed(ItemStack stack, IBlockState state, float originSpeed) {
        if (!mistStoneBreakers.isEmpty() && mistStoneBreakers.containsKey(stack.func_77973_b())) {
            int[] speed = mistStoneBreakers.get(stack.func_77973_b());
            int m = state.func_177230_c() instanceof IMistStoneBasic ? speed[2] : (state.func_177230_c() instanceof IMistStoneUpper && ((IMistStoneUpper)state.func_177230_c()).isUpperStone(state) ? speed[1] : speed[0]);
            return originSpeed * (float)m;
        }
        return originSpeed;
    }
}

