/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.registry;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.MathHelper;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.registry.MistRegistry;

public interface IMistHarvest {
    public HarvestType getHarvestType();

    public static HarvestType getHarvestType(Block block) {
        if (block instanceof BlockCrops) {
            if (block == Blocks.field_150469_bN) {
                return HarvestType.WP2_3;
            }
            if (block == Blocks.field_150459_bM) {
                return HarvestType.WP3_3;
            }
            if (block == Blocks.field_185773_cZ) {
                return HarvestType.WP2_3;
            }
            if (block == Blocks.field_150464_aj) {
                return HarvestType.WP1_2;
            }
            if (block == Blocks.field_150394_bc) {
                return HarvestType.WP3_3;
            }
            if (block == Blocks.field_150393_bb) {
                return HarvestType.WP3_3;
            }
        } else if (block instanceof IMistHarvest) {
            return ((IMistHarvest)block).getHarvestType();
        }
        return MistRegistry.getHarvestType(block);
    }

    public static boolean isSoilSuitable(Block crop, IBlockState soil) {
        if (soil.func_177230_c() instanceof IWettable) {
            HarvestType type;
            int i = ((IWettable)soil.func_177230_c()).getWaterPerm(soil);
            return i >= (type = IMistHarvest.getHarvestType(crop)).getMinWaterPerm() && i <= type.getMaxWaterPerm();
        }
        return false;
    }

    public static enum HarvestType {
        WP1_1(1, 1),
        WP1_2(1, 2),
        WP1_3(1, 3),
        WP2_2(2, 2),
        WP2_3(2, 3),
        WP3_3(3, 3);

        private final int minWaterPerm;
        private final int maxWaterPerm;

        private HarvestType(int minWaterPerm, int maxWaterPerm) {
            this.minWaterPerm = MathHelper.func_76125_a((int)minWaterPerm, (int)1, (int)3);
            this.maxWaterPerm = MathHelper.func_76125_a((int)maxWaterPerm, (int)1, (int)3);
        }

        public int getMinWaterPerm() {
            return this.minWaterPerm;
        }

        public int getMaxWaterPerm() {
            return this.maxWaterPerm;
        }
    }
}

