/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.item;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec2f;
import ru.liahim.mist.api.item.IFilter;
import ru.liahim.mist.capability.handler.IMistCapaHandler;
import ru.liahim.mist.util.ItemStackMapKey;

public interface IMask {
    public static final HashMap<ItemStackMapKey, Vec2f> respirators = Maps.newHashMap();
    public static final HashMap<ItemStackMapKey, Integer> filters = Maps.newHashMap();

    default public void onWornTick(ItemStack stack, EntityLivingBase player) {
    }

    default public void onEquippedMask(ItemStack stack, EntityLivingBase player) {
    }

    public static void onEquipped(ItemStack stack, EntityLivingBase player) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IMask) {
            ((IMask)stack.func_77973_b()).onEquippedMask(stack, player);
        }
    }

    default public void onUnequippedMask(ItemStack stack, EntityLivingBase player) {
    }

    public static void onUnequipped(ItemStack stack, EntityLivingBase player) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IMask) {
            ((IMask)stack.func_77973_b()).onUnequippedMask(stack, player);
        }
    }

    default public boolean canEquipMask(@Nonnull ItemStack stack, EntityLivingBase player) {
        return !IMask.isMaskInHelmetSlot((Entity)player);
    }

    public static boolean canEquip(ItemStack stack, EntityLivingBase player) {
        if (IMask.isMask(stack)) {
            if (stack.func_77973_b() instanceof IMask) {
                return ((IMask)stack.func_77973_b()).canEquipMask(stack, player);
            }
            return !IMask.isMaskInHelmetSlot((Entity)player);
        }
        return false;
    }

    default public boolean canUnequipMask(ItemStack stack, EntityLivingBase player) {
        return true;
    }

    public static boolean canUnequip(ItemStack stack, EntityLivingBase player) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof IMask) {
            return ((IMask)stack.func_77973_b()).canUnequipMask(stack, player);
        }
        return true;
    }

    default public boolean willAutoSync(ItemStack stack, EntityLivingBase player) {
        return false;
    }

    default public boolean isRespirator() {
        return false;
    }

    public static boolean isRespirator(ItemStack stack) {
        return stack.func_190926_b() ? false : (stack.func_77973_b() instanceof IMask ? ((IMask)stack.func_77973_b()).isRespirator() : respirators.containsKey(new ItemStackMapKey(stack)));
    }

    default public boolean canEat() {
        return false;
    }

    public static boolean canEat(ItemStack stack) {
        if (stack.func_190926_b()) {
            return true;
        }
        if (stack.func_77973_b() instanceof IMask) {
            return ((IMask)stack.func_77973_b()).canEat();
        }
        ItemStackMapKey key = new ItemStackMapKey(stack);
        if (!respirators.containsKey(key)) {
            return true;
        }
        return IMask.respirators.get((Object)key).field_189983_j == 1.0f;
    }

    default public float getImpermeability() {
        return 90.0f;
    }

    public static float getImpermeability(ItemStack mask) {
        ItemStackMapKey key;
        float i = mask.func_77973_b() instanceof IMask ? ((IMask)mask.func_77973_b()).getImpermeability() : (!respirators.containsKey(key = new ItemStackMapKey(mask)) ? 0.0f : IMask.respirators.get((Object)key).field_189982_i);
        int level = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185298_f, (ItemStack)mask);
        i += (100.0f - i) * (float)level * 0.1f;
        return i;
    }

    public static boolean isMaskInSlot(Entity player) {
        return player instanceof EntityPlayer && IMask.isMask(IMistCapaHandler.getHandler((EntityPlayer)player).getMask());
    }

    public static boolean isMaskInHelmetSlot(Entity player) {
        return player instanceof EntityPlayer && IMask.isMask(((EntityPlayer)player).func_184582_a(EntityEquipmentSlot.HEAD));
    }

    public static boolean isMask(ItemStack stack) {
        return !stack.func_190926_b() && (stack.func_77973_b() instanceof IMask || stack.func_179543_a("MistFilter") != null);
    }

    public static ItemStack getFilter(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a("MistFilter");
        return tag != null ? new ItemStack(tag) : ItemStack.field_190927_a;
    }

    public static float damageFilter(ItemStack mask, int damage, IMistCapaHandler mistCapa) {
        ItemStack filter = IMask.getFilter(mask);
        if (!filter.func_190926_b()) {
            int durability = IMask.getFilterDurability(filter);
            float filteringDepth = IMask.getFilteringDepth(filter);
            filteringDepth *= IMask.getImpermeability(mask) / 100.0f;
            if (durability == filter.func_77958_k()) {
                if ((damage += filter.func_77952_i()) < durability) {
                    filter.func_77964_b(damage);
                    mask.func_77978_p().func_74782_a("MistFilter", (NBTBase)filter.serializeNBT());
                    mask.func_77978_p().func_74768_a("MistFilterDurability", damage);
                } else {
                    mask.func_77978_p().func_82580_o("MistFilter");
                    mask.func_77978_p().func_82580_o("MistFilterDurability");
                }
            } else if ((damage += mask.func_77978_p().func_74762_e("MistFilterDurability")) <= durability) {
                mask.func_77978_p().func_74768_a("MistFilterDurability", damage);
            } else {
                mask.func_77978_p().func_82580_o("MistFilter");
                mask.func_77978_p().func_82580_o("MistFilterDurability");
            }
            mistCapa.setMaskChanged(true, false);
            return filteringDepth;
        }
        return 0.0f;
    }

    public static int getFilterDurability(ItemStack filter) {
        if (filter.func_77984_f()) {
            return filter.func_77958_k();
        }
        ItemStackMapKey key = new ItemStackMapKey(filter);
        return !filters.isEmpty() && filters.containsKey(key) ? filters.get(key) : 1000;
    }

    public static float getFilteringDepth(ItemStack filter) {
        if (filter.func_77973_b() instanceof IFilter) {
            return ((IFilter)filter.func_77973_b()).getFilteringDepth();
        }
        return filter.func_77942_o() ? filter.func_77978_p().func_74760_g("MistFilteringDepth") : 0.0f;
    }
}

