/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.block;

import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSponge;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockWettable;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public interface IWettable {
    public static final PropertyBool WET = PropertyBool.func_177716_a((String)"wet");

    default public boolean update(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            boolean fog = MistWorld.isPosInFog(world, pos.func_177981_b(2));
            boolean lava = IWettable.checkLava(world, pos);
            boolean rain = this.isRainUp(world, pos.func_177984_a(), rand);
            boolean rand2 = this.isChance(state, rand);
            Vector2f waterType = IWettable.checkFluidDist(world, pos, EnumFacing.UP, this.getWaterPerm(state), 0);
            int waterDist = (int)waterType.getY();
            if (!((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
                boolean checkWet = false;
                if (waterDist == 0 || rain || !lava && (waterDist > 0 || fog && rand2)) {
                    checkWet = true;
                } else if (rand2 && !lava) {
                    IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
                    if (this.isUpWet(stateUp)) {
                        checkWet = true;
                    } else {
                        EnumFacing side;
                        boolean isClose = true;
                        if (!world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                            isClose = false;
                            if (MistWorld.getHumi(world, pos.func_177984_a(), 0.0f) >= (float)this.getTopProtectPercent(state, false)) {
                                checkWet = true;
                            }
                        }
                        if (!checkWet && (isClose || this.getTopProtectPercent(state, false) > this.getSideProtectPercent(state, false)) && (side = this.checkAir(world, pos, rand)) != EnumFacing.DOWN) {
                            isClose = false;
                            if (MistWorld.getHumi(world, pos.func_177972_a(side), 0.0f) >= (float)this.getSideProtectPercent(state, false)) {
                                checkWet = true;
                            }
                        }
                        if (isClose && MistWorld.getHumi(world, pos, 0.0f) >= (float)this.getCloseProtectPercent(state, false)) {
                            checkWet = true;
                        }
                    }
                }
                if (!checkWet) {
                    return this.doIfDry(world, pos, state, lava, rand);
                }
                if ((fog || waterType.getX() < 0.0f) && state.func_177230_c() != this.getAcidBlock(state)) {
                    return this.setAcid(world, pos, state, waterDist, rand);
                }
                return this.setWet(world, pos, state, waterDist, rand);
            }
            boolean checkDry = false;
            if (!(waterDist == 0 || rain || !lava && (waterDist > 0 || fog && rand2) || !rand2)) {
                if (lava) {
                    checkDry = true;
                } else if (!world.func_72896_J() && !this.isUpWet(world.func_180495_p(pos.func_177984_a()))) {
                    EnumFacing side;
                    boolean isClose = true;
                    if (!world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN)) {
                        isClose = false;
                        if (MistWorld.getHumi(world, pos.func_177984_a(), 0.0f) <= (float)this.getTopProtectPercent(state, true)) {
                            checkDry = true;
                        }
                    }
                    if (!checkDry && (isClose || this.getTopProtectPercent(state, true) < this.getSideProtectPercent(state, true)) && (side = this.checkAir(world, pos, rand)) != EnumFacing.DOWN) {
                        isClose = false;
                        if (MistWorld.getHumi(world, pos.func_177972_a(side), 0.0f) <= (float)this.getSideProtectPercent(state, true)) {
                            checkDry = true;
                        }
                    }
                    if (isClose && MistWorld.getHumi(world, pos, 0.0f) <= (float)this.getCloseProtectPercent(state, true)) {
                        checkDry = true;
                    }
                }
            }
            if (checkDry) {
                return this.setDry(world, pos, state, rand);
            }
            if ((fog || waterType.getX() < 0.0f) && state.func_177230_c() != this.getAcidBlock(state)) {
                return this.setAcid(world, pos, state, waterDist, rand);
            }
            return this.doIfWet(world, pos, state, waterType, fog, rand);
        }
        return false;
    }

    default public boolean isChance(IBlockState state, Random rand) {
        return rand.nextInt((5 - this.getWaterPerm(state)) * 2) == 0;
    }

    default public boolean isRainUp(World world, BlockPos pos, Random rand) {
        return world.func_175727_C(pos);
    }

    default public boolean isUpWet(IBlockState stateUp) {
        Material matUp = stateUp.func_185904_a();
        return matUp == Material.field_151597_y || matUp == Material.field_151596_z || matUp == Material.field_151588_w || stateUp == Blocks.field_150360_v.func_176223_P().func_177226_a((IProperty)BlockSponge.field_176313_a, (Comparable)Boolean.valueOf(true));
    }

    default public EnumFacing checkAir(World world, BlockPos pos, Random rand) {
        EnumFacing face = EnumFacing.field_176754_o[rand.nextInt(4)];
        if (!world.isSideSolid(pos.func_177972_a(face), face.func_176734_d())) {
            return face;
        }
        return EnumFacing.DOWN;
    }

    default public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        return false;
    }

    default public boolean doIfDry(World world, BlockPos pos, IBlockState state, boolean lava, Random rand) {
        return false;
    }

    default public boolean setWet(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        return world.func_180501_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)), 2);
    }

    default public boolean setDry(World world, BlockPos pos, IBlockState state, Random rand) {
        return world.func_180501_a(pos, state.func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)), 2);
    }

    default public boolean setAcid(World world, BlockPos pos, IBlockState state, int waterDist, Random rand) {
        if (this.getAcidBlock(state) == null) {
            return false;
        }
        if (this.getAcidBlock(state) instanceof IWettable) {
            return world.func_180501_a(pos, this.getAcidBlock(state).func_176223_P().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(true)), 2);
        }
        return world.func_180501_a(pos, this.getAcidBlock(state).func_176223_P(), 2);
    }

    public static boolean checkWater(World world, BlockPos pos, EnumFacing direct) {
        for (EnumFacing face : FacingHelper.NOTDOWN) {
            BlockPos checkPos;
            if (face.func_176734_d() == direct || !world.func_175667_e(checkPos = pos.func_177972_a(face)) || world.func_180495_p(checkPos).func_185904_a() != Material.field_151586_h || world.func_180495_p(checkPos).func_177230_c() == MistBlocks.ACID_BLOCK) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWater(World world, BlockPos pos) {
        return IWettable.checkWater(world, pos, EnumFacing.UP);
    }

    public static boolean checkAcid(World world, BlockPos pos, EnumFacing direct) {
        for (EnumFacing face : FacingHelper.NOTDOWN) {
            BlockPos checkPos;
            if (face.func_176734_d() == direct || !world.func_175667_e(checkPos = pos.func_177972_a(face)) || world.func_180495_p(checkPos).func_177230_c() != MistBlocks.ACID_BLOCK) continue;
            return true;
        }
        return false;
    }

    public static boolean checkAcid(World world, BlockPos pos) {
        return IWettable.checkAcid(world, pos, EnumFacing.UP);
    }

    public static boolean checkLava(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            BlockPos checkPos = pos.func_177972_a(face);
            if (!world.func_175667_e(checkPos) || world.func_180495_p(checkPos).func_185904_a() != Material.field_151587_i) continue;
            return true;
        }
        return false;
    }

    public static int checkFluid(World world, BlockPos pos, EnumFacing direct) {
        int i = 0;
        for (EnumFacing face : FacingHelper.NOTDOWN) {
            BlockPos checkPos;
            if (face.func_176734_d() == direct || !world.func_175667_e(checkPos = pos.func_177972_a(face))) continue;
            if (world.func_180495_p(checkPos).func_177230_c() == MistBlocks.ACID_BLOCK) {
                return -1;
            }
            if (world.func_180495_p(checkPos).func_185904_a() != Material.field_151586_h) continue;
            i = 1;
        }
        return i;
    }

    public static int checkFluid(World world, BlockPos pos) {
        return IWettable.checkFluid(world, pos, EnumFacing.UP);
    }

    public static Vector2f checkFluidDist(World world, BlockPos pos, EnumFacing direct, @Nullable int waterPerm, int dist) {
        Vector2f fluidDist = new Vector2f(0.0f, -1.0f);
        IBlockState state = world.func_180495_p(pos);
        if (waterPerm == 0 && state.func_177230_c() instanceof IWettable) {
            waterPerm = ((IWettable)state.func_177230_c()).getWaterPerm(state);
        }
        waterPerm = MathHelper.func_76125_a((int)waterPerm, (int)1, (int)3);
        int i = IWettable.canTransitFluid(state);
        if (dist == 0 || dist < 3 && waterPerm > dist && i != 0) {
            int fluidType = IWettable.checkFluid(world, pos, direct);
            if (fluidType != 0 && (dist == 0 || i == 2 || i == fluidType)) {
                fluidDist.set((float)fluidType, (float)dist);
            } else if (waterPerm > dist + 1) {
                float a = -1.0f;
                float w = -1.0f;
                fluidDist = IWettable.checkFluidDist(world, pos.func_177984_a(), EnumFacing.UP, 0, dist + 1);
                if (fluidDist.getX() < 0.0f) {
                    a = fluidDist.getY();
                } else if (fluidDist.getX() > 0.0f) {
                    w = fluidDist.getY();
                }
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos checkPos = pos.func_177972_a(face);
                    if (direct == face.func_176734_d() || !world.func_175667_e(checkPos)) continue;
                    fluidDist = IWettable.checkFluidDist(world, checkPos, face, 0, dist + 1);
                    if (fluidDist.getX() < 0.0f) {
                        a = a < 0.0f ? fluidDist.getY() : Math.min(a, fluidDist.getY());
                        continue;
                    }
                    if (!(fluidDist.getX() > 0.0f)) continue;
                    w = w < 0.0f ? fluidDist.getY() : Math.min(w, fluidDist.getY());
                }
                if (a > 0.0f && (dist == 0 || i < 0 || i == 2)) {
                    fluidDist.set(-1.0f, a);
                } else if (w > 0.0f) {
                    fluidDist.set(1.0f, w);
                } else {
                    fluidDist.set(0.0f, -1.0f);
                }
            }
        }
        return fluidDist;
    }

    public static int checkWaterDist(World world, BlockPos pos, EnumFacing direct, @Nullable int waterPerm, int dist) {
        int waterDist = -1;
        IBlockState state = world.func_180495_p(pos);
        if (waterPerm == 0 && state.func_177230_c() instanceof MistBlockWettable) {
            waterPerm = ((MistBlockWettable)state.func_177230_c()).getWaterPerm(state);
        }
        waterPerm = MathHelper.func_76125_a((int)waterPerm, (int)1, (int)3);
        if (dist == 0 || dist < 3 && waterPerm > dist && IWettable.canTransitWater(state)) {
            if (IWettable.checkWater(world, pos, direct)) {
                waterDist = dist;
            } else if (waterPerm > dist + 1) {
                waterDist = IWettable.checkWaterDist(world, pos.func_177984_a(), EnumFacing.UP, 0, dist + 1);
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos checkPos = pos.func_177972_a(face);
                    if (waterDist >= 0 || direct == face.func_176734_d() || !world.func_175667_e(checkPos)) continue;
                    waterDist = IWettable.checkWaterDist(world, checkPos, face, 0, dist + 1);
                }
            }
        }
        return waterDist;
    }

    public static int checkAcidDist(World world, BlockPos pos, EnumFacing direct, @Nullable int waterPerm, int dist) {
        int acidDist = -1;
        IBlockState state = world.func_180495_p(pos);
        if (waterPerm == 0 && state.func_177230_c() instanceof MistBlockWettable) {
            waterPerm = ((MistBlockWettable)state.func_177230_c()).getWaterPerm(state);
        }
        waterPerm = MathHelper.func_76125_a((int)waterPerm, (int)1, (int)3);
        if (dist == 0 || dist < 3 && waterPerm > dist && IWettable.canTransitAcid(state)) {
            if (IWettable.checkAcid(world, pos, direct)) {
                acidDist = dist;
            } else if (waterPerm > dist + 1) {
                acidDist = IWettable.checkAcidDist(world, pos.func_177984_a(), EnumFacing.UP, 0, dist + 1);
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    BlockPos checkPos = pos.func_177972_a(face);
                    if (acidDist >= 0 || direct == face.func_176734_d() || !world.func_175667_e(checkPos)) continue;
                    acidDist = IWettable.checkAcidDist(world, checkPos, face, 0, dist + 1);
                }
            }
        }
        return acidDist;
    }

    public static boolean canTransitWater(IBlockState state) {
        if (state.func_177230_c() instanceof IWettable && ((IWettable)state.func_177230_c()).isAcid()) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockSand) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockGravel) {
            return true;
        }
        return state.func_177230_c() instanceof IWettable && ((IWettable)state.func_177230_c()).getWaterPerm(state) > 1 && (Boolean)state.func_177229_b((IProperty)WET) != false;
    }

    public static boolean canTransitAcid(IBlockState state) {
        if (state.func_177230_c() instanceof BlockSand) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockGravel) {
            return true;
        }
        return state.func_177230_c() instanceof IWettable && ((IWettable)state.func_177230_c()).isAcid() && ((IWettable)state.func_177230_c()).getWaterPerm(state) > 1 && (Boolean)state.func_177229_b((IProperty)WET) != false;
    }

    public static int canTransitFluid(IBlockState state) {
        if (state.func_177230_c() instanceof BlockSand) {
            return 2;
        }
        if (state.func_177230_c() instanceof BlockGravel) {
            return 2;
        }
        if (state.func_177230_c() instanceof IWettable && ((IWettable)state.func_177230_c()).getWaterPerm(state) > 1 && ((Boolean)state.func_177229_b((IProperty)WET)).booleanValue()) {
            if (state.func_177230_c() instanceof IWettable && ((IWettable)state.func_177230_c()).isAcid()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int getWaterPerm(IBlockState var1);

    default public int getTopProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? 50 : 100;
    }

    default public int getSideProtectPercent(IBlockState state, boolean isWet) {
        return this.getTopProtectPercent(state, isWet);
    }

    default public int getCloseProtectPercent(IBlockState state, boolean isWet) {
        return isWet ? this.getTopProtectPercent(state, true) - 20 : this.getTopProtectPercent(state, false) + 20;
    }

    public boolean isAcid();

    public void setAcidBlock(Block var1);

    public Block getAcidBlock(IBlockState var1);
}

