/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.advancement.criterion;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ru.liahim.mist.api.advancement.FogDamagePredicate;

public class FogDamageTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("mist", "fog_damage");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancements) {
        this.listeners.remove(playerAdvancements);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        LocationPredicate location = LocationPredicate.func_193454_a((JsonElement)JsonUtils.func_151218_a((JsonObject)json, (String)"location", (JsonObject)new JsonObject()));
        FogDamagePredicate fogDamage = FogDamagePredicate.deserialize((JsonElement)JsonUtils.func_151218_a((JsonObject)json, (String)"damage", (JsonObject)new JsonObject()));
        return new Instance(location, fogDamage);
    }

    public void trigger(EntityPlayerMP player, World world, BlockPos pos, FogDamagePredicate.FogDamageType fogDamage, float centerDamage, @Nullable Boolean mask, @Nullable Boolean suit, @Nullable Boolean adsorbent) {
        Listeners listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(world, pos, fogDamage, centerDamage, mask, suit, adsorbent);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(World world, BlockPos pos, FogDamagePredicate.FogDamageType fogDamage, float centerDamage, @Nullable Boolean mask, @Nullable Boolean suit, @Nullable Boolean adsorbent) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (!((Instance)listener.func_192158_a()).test(world, pos, fogDamage, centerDamage, mask, suit, adsorbent)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        private final LocationPredicate location;
        private final FogDamagePredicate fogDamage;

        public Instance(LocationPredicate location, FogDamagePredicate fogDamage) {
            super(ID);
            this.location = location;
            this.fogDamage = fogDamage;
        }

        public boolean test(World world, BlockPos pos, FogDamagePredicate.FogDamageType damageType, float centerDamage, @Nullable Boolean mask, @Nullable Boolean suit, @Nullable Boolean adsorbent) {
            if (world instanceof WorldServer) {
                boolean loc = this.location == LocationPredicate.field_193455_a || this.location.func_193453_a((WorldServer)world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
                return loc && this.fogDamage.test(damageType, centerDamage, mask, suit, adsorbent);
            }
            return false;
        }
    }
}

