/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.JsonUtils;

public enum PortalType implements IStringSerializable
{
    ANY("any"),
    DIMENSION("dimension"),
    IN_VOID("in_void");

    private static final HashMap<String, PortalType> NAME_LOOKUP;
    private final String name;

    private PortalType(String name) {
        this.name = name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static PortalType getTypeByName(String name) {
        if (NAME_LOOKUP.containsKey(name)) {
            return NAME_LOOKUP.get(name);
        }
        return null;
    }

    public boolean test(PortalType type) {
        return this == ANY && type != IN_VOID || this == type;
    }

    public static PortalType deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"portal");
            String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"portal");
            PortalType type = PortalType.getTypeByName(name);
            if (type != null) {
                return type;
            }
            throw new JsonSyntaxException("Unknown portal type '" + name + "'");
        }
        return ANY;
    }

    static {
        NAME_LOOKUP = new HashMap();
        for (PortalType type : PortalType.values()) {
            NAME_LOOKUP.put(type.func_176610_l(), type);
        }
    }
}

