/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.JsonUtils;

public class FogDamagePredicate {
    public static FogDamagePredicate ANY = new FogDamagePredicate();
    private final FogDamageType damageType;
    private final MinMaxBounds centerDamage;
    private final Boolean mask;
    private final Boolean suit;
    private final Boolean adsorbent;

    public FogDamagePredicate(FogDamageType damageType, MinMaxBounds centerDamage, @Nullable Boolean mask, @Nullable Boolean suit, @Nullable Boolean absorbent) {
        this.damageType = damageType;
        this.centerDamage = centerDamage;
        this.mask = mask;
        this.suit = suit;
        this.adsorbent = absorbent;
    }

    public FogDamagePredicate() {
        this.damageType = FogDamageType.ANY;
        this.centerDamage = MinMaxBounds.field_192516_a;
        this.mask = null;
        this.suit = null;
        this.adsorbent = null;
    }

    public boolean test(FogDamageType damageType, float centerDamage, @Nullable Boolean mask, @Nullable Boolean suit, @Nullable Boolean adsorbent) {
        if (!this.damageType.test(damageType)) {
            return false;
        }
        if (!this.centerDamage.func_192514_a(centerDamage)) {
            return false;
        }
        if (this.mask != null && mask != null && this.mask.booleanValue() != mask.booleanValue()) {
            return false;
        }
        if (this.suit != null && suit != null && this.suit.booleanValue() != suit.booleanValue()) {
            return false;
        }
        return this.adsorbent == null || adsorbent == null || this.adsorbent.booleanValue() == adsorbent.booleanValue();
    }

    public static FogDamagePredicate deserialize(@Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            FogDamageType damageType;
            JsonObject jsonobject = JsonUtils.func_151210_l((JsonElement)element, (String)"damage");
            if (jsonobject.has("type")) {
                String name = JsonUtils.func_151200_h((JsonObject)jsonobject, (String)"type");
                damageType = FogDamageType.getTypeByName(name);
                if (damageType == null) {
                    damageType = FogDamageType.ANY;
                    throw new JsonSyntaxException("Unknown fog damage type '" + name + "'");
                }
            } else {
                damageType = FogDamageType.ANY;
            }
            MinMaxBounds centerDamage = MinMaxBounds.func_192515_a((JsonElement)jsonobject.get("center_damage"));
            Boolean mask = jsonobject.has("mask") ? Boolean.valueOf(JsonUtils.func_151212_i((JsonObject)jsonobject, (String)"mask")) : null;
            Boolean suit = jsonobject.has("suit") ? Boolean.valueOf(JsonUtils.func_151212_i((JsonObject)jsonobject, (String)"suit")) : null;
            Boolean absorbent = jsonobject.has("absorbent") ? Boolean.valueOf(JsonUtils.func_151212_i((JsonObject)jsonobject, (String)"absorbent")) : null;
            return new FogDamagePredicate(damageType, centerDamage, mask, suit, absorbent);
        }
        return ANY;
    }

    public static enum FogDamageType implements IStringSerializable
    {
        ANY("any"),
        BY_FOG("by_fog"),
        BY_ACID("by_acid"),
        BY_RAIN("by_rain");

        private static final HashMap<String, FogDamageType> NAME_LOOKUP;
        private final String name;

        private FogDamageType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static FogDamageType getTypeByName(String name) {
            if (NAME_LOOKUP.containsKey(name)) {
                return NAME_LOOKUP.get(name);
            }
            return null;
        }

        public boolean test(FogDamageType damageType) {
            return this == ANY || this == damageType;
        }

        static {
            NAME_LOOKUP = new HashMap();
            for (FogDamageType type : FogDamageType.values()) {
                NAME_LOOKUP.put(type.func_176610_l(), type);
            }
        }
    }
}

