/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.api.advancement;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import ru.liahim.mist.api.advancement.ICriterionInstanceTestable2;

public abstract class BaseCriterionTrigger2<D1, D2, T extends ICriterionInstanceTestable2<D1, D2>>
implements ICriterionTrigger<T> {
    private final Map<PlayerAdvancements, Listeners<D1, D2, T>> listeners = Maps.newHashMap();
    private final ResourceLocation id;

    protected BaseCriterionTrigger2(ResourceLocation id) {
        this.id = id;
    }

    public ResourceLocation func_192163_a() {
        return this.id;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Listeners<D1, D2, T> listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners == null) {
            listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, listeners);
        }
        listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<T> listener) {
        Listeners<D1, D2, T> listeners = this.listeners.get(playerAdvancementsIn);
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public void trigger(EntityPlayerMP player, D1 criterionData1, D2 criterionData2) {
        Listeners<D1, D2, T> listeners = this.listeners.get(player.func_192039_O());
        if (listeners != null) {
            listeners.trigger(player, criterionData1, criterionData2);
        }
    }

    static class Listeners<D1, D2, T extends ICriterionInstanceTestable2<D1, D2>> {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<T>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<T> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<T> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(EntityPlayerMP player, D1 criterionData1, D2 criterionData2) {
            List list = null;
            for (ICriterionTrigger.Listener<T> listener : this.listeners) {
                if (!((ICriterionInstanceTestable2)listener.func_192158_a()).test(player, criterionData1, criterionData2)) continue;
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener1 : list) {
                    listener1.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }
}

