/*
 * Decompiled with CFR 0.152.
 */
package com.polipo.compass;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="giacomoscompass", version="1.0.6", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class CompassMod {
    public static final String MODID = "giacomoscompass";
    public static final String VERSION = "1.0.6";
    HashMap<Long, CompassData> dataById = new HashMap();
    HashMap<String, BlockPos> posByPlayer = new HashMap();
    IItemPropertyGetter original;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        if (e.getSide() == Side.CLIENT) {
            this.original = Items.field_151111_aL.func_185045_a(new ResourceLocation("angle"));
        }
        Items.field_151111_aL.func_185043_a(new ResourceLocation("angle"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                double d0;
                EntityLivingBase entity;
                if (entityIn == null && !stack.func_82839_y()) {
                    return CompassMod.this.original.func_185085_a(stack, worldIn, entityIn);
                }
                boolean flag = entityIn != null;
                Object object = entity = flag ? entityIn : stack.func_82836_z();
                if (worldIn == null) {
                    worldIn = entity.field_70170_p;
                }
                CompassData cd = null;
                NBTTagCompound compound = stack.func_77978_p();
                if (compound == null || !compound.func_74764_b("giacomosbussolaID")) {
                    return CompassMod.this.original.func_185085_a(stack, worldIn, entityIn);
                }
                long id = compound.func_74763_f("giacomosbussolaID");
                boolean fuzzy = !compound.func_74764_b("giacomosbussolaX");
                cd = CompassMod.this.dataById.get(id);
                if (cd == null) {
                    cd = new CompassData();
                    CompassMod.this.dataById.put(id, cd);
                }
                if (worldIn.field_73011_w.func_76569_d() && !fuzzy) {
                    double d1 = flag ? (double)entity.field_70177_z : this.getFrameRotation((EntityItemFrame)entity);
                    float x = compound.func_74760_g("giacomosbussolaX");
                    float z = compound.func_74760_g("giacomosbussolaZ");
                    double d2 = Math.atan2((double)z - entity.field_70161_v, (double)x - entity.field_70165_t);
                    d0 = Math.PI - (((d1 %= 360.0) - 90.0) * 0.01745329238474369 - d2);
                } else {
                    d0 = Math.random() * (Math.PI * 2);
                }
                if (flag) {
                    d0 = this.wobble(worldIn, d0, cd);
                }
                float f = (float)(d0 / (Math.PI * 2));
                return MathHelper.func_188207_b((float)f, (float)1.0f);
            }

            @SideOnly(value=Side.CLIENT)
            private double getFrameRotation(EntityItemFrame p_185094_1_) {
                return MathHelper.func_188209_b((int)(180 + p_185094_1_.field_174860_b.func_176736_b() * 90));
            }

            @SideOnly(value=Side.CLIENT)
            private double wobble(World p_185093_1_, double p_185093_2_, CompassData cd) {
                if (p_185093_1_.func_82737_E() != cd.lastUpdateTick) {
                    cd.lastUpdateTick = p_185093_1_.func_82737_E();
                    double d0 = p_185093_2_ - cd.rotation;
                    d0 %= Math.PI * 2;
                    d0 = MathHelper.func_151237_a((double)d0, (double)-1.0, (double)1.0);
                    cd.rota += d0 * 0.1;
                    cd.rota *= 0.8;
                    cd.rotation += cd.rota;
                }
                return cd.rotation;
            }
        });
    }

    @SubscribeEvent
    public void rightclick(PlayerInteractEvent.RightClickBlock e) {
        this.posByPlayer.put(e.getEntityPlayer().func_70005_c_(), e.getPos());
    }

    @SubscribeEvent
    public void onAnvilRepair(AnvilRepairEvent e) {
        float posz;
        float posy;
        float posx;
        EntityPlayer ep = e.getEntityPlayer();
        if (ep == null) {
            return;
        }
        InventoryPlayer invp = ep.field_71071_by;
        ItemStack inputStack = e.getItemInput();
        ItemStack outputStack = invp.func_70445_o();
        if (outputStack.func_77973_b() != Items.field_151111_aL) {
            return;
        }
        NBTTagCompound compound2 = outputStack.func_77978_p();
        if (compound2 == null) {
            return;
        }
        BlockPos position = this.posByPlayer.get(ep.func_70005_c_());
        if (position == null) {
            position = ep.func_180425_c();
            posx = (float)ep.func_174791_d().field_72450_a;
            posy = (float)ep.func_174791_d().field_72448_b;
            posz = (float)ep.func_174791_d().field_72449_c;
        } else {
            posx = (float)((double)position.func_177958_n() + 0.5);
            posy = (float)((double)position.func_177956_o() + 0.5);
            posz = (float)((double)position.func_177952_p() + 0.5);
        }
        ItemStack normal = new ItemStack(Items.field_151111_aL);
        if (outputStack.func_82833_r().equals(normal.func_82833_r())) {
            compound2.func_82580_o("giacomosbussolaX");
            compound2.func_82580_o("giacomosbussolaY");
            compound2.func_82580_o("giacomosbussolaZ");
            compound2.func_82580_o("giacomosbussolaID");
            int repairCost = compound2.func_74762_e("RepairCost");
            if (repairCost == 0) {
                compound2.func_82580_o("display");
                compound2.func_82580_o("RepairCost");
            }
            if (compound2.func_82582_d()) {
                outputStack.func_77982_d(null);
            }
        } else if (!inputStack.func_82833_r().equals(outputStack.func_82833_r())) {
            if (compound2.func_74764_b("giacomosbussolaID")) {
                this.dataById.remove(compound2.func_74763_f("giacomosbussolaID"));
            }
            compound2.func_74772_a("giacomosbussolaID", System.currentTimeMillis());
            if (ep.field_70170_p.field_73011_w.func_76569_d()) {
                compound2.func_74776_a("giacomosbussolaX", posx);
                compound2.func_74776_a("giacomosbussolaY", posy);
                compound2.func_74776_a("giacomosbussolaZ", posz);
            } else {
                compound2.func_82580_o("giacomosbussolaX");
                compound2.func_82580_o("giacomosbussolaY");
                compound2.func_82580_o("giacomosbussolaZ");
            }
        }
    }

    class CompassData {
        double rotation;
        double rota;
        long lastUpdateTick;

        CompassData() {
        }
    }
}

